/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ODataTypeParametrizedIJsonBackedTypedAdapter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FallbackTypeAdapterFactory
implements TypeAdapterFactory {
    private static final String NO_KNOWN_VALUE = "unexpectedValue";
    private final ILogger logger;
    private static final TypeAdapter<Void> voidAdapter = new TypeAdapter<Void>(){

        @Override
        public void write(JsonWriter out, Void value) throws IOException {
            out.nullValue();
        }

        @Override
        public Void read(JsonReader in) {
            return null;
        }
    };

    @SuppressFBWarnings
    public FallbackTypeAdapterFactory(@Nonnull ILogger logger) {
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        this.logger = logger;
    }

    @Override
    @Nullable
    @SuppressFBWarnings
    public <T> TypeAdapter<T> create(@Nonnull Gson gson, @Nonnull TypeToken<T> type) {
        Objects.requireNonNull(type, "parameter type cannot be null");
        Class<T> rawType = type.getRawType();
        if (rawType.isEnum()) {
            return new EnumTypeAdapter<T>(rawType, this.logger);
        }
        if (rawType == Void.class) {
            return voidAdapter;
        }
        if (IJsonBackedObject.class.isAssignableFrom(type.getRawType())) {
            TypeAdapter<IJsonBackedObject> delegatedAdapter = gson.getDelegateAdapter(this, type);
            if (!(delegatedAdapter instanceof ReflectiveTypeAdapterFactory.Adapter)) {
                return null;
            }
            return new ODataTypeParametrizedIJsonBackedTypedAdapter(this, gson, delegatedAdapter, type, this.logger);
        }
        return null;
    }

    private static final class EnumTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Map<String, T> enumValues;
        private final ILogger logger;

        EnumTypeAdapter(Class<T> cls, ILogger logger) {
            this.logger = logger;
            HashMap<String, T> enumValues = new HashMap<String, T>();
            for (T constant : cls.getEnumConstants()) {
                enumValues.put(constant.toString(), constant);
            }
            this.enumValues = enumValues;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, value.toString()));
            }
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            String value = reader.nextString();
            T incoming = this.enumValues.get(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            if (incoming == null) {
                this.logger.logDebug(String.format("The following value %s could not be recognized as a member of the enum", value));
                return this.enumValues.get(FallbackTypeAdapterFactory.NO_KNOWN_VALUE);
            }
            return incoming;
        }
    }
}

