/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnumSetSerializer {
    private final Gson gson;

    public EnumSetSerializer(@Nonnull ILogger logger) {
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        this.gson = new GsonBuilder().registerTypeAdapterFactory(new FallbackTypeAdapterFactory(logger)).create();
    }

    @Nullable
    public EnumSet<?> deserialize(@Nonnull Type type, @Nonnull String jsonStrToDeserialize) {
        Objects.requireNonNull(type, "parameter type cannot be null");
        Objects.requireNonNull(jsonStrToDeserialize, "parameter jsonStrToDeserialize cannot be null");
        String arrayString = "[" + jsonStrToDeserialize + "]";
        return jsonStrToDeserialize == null ? null : (EnumSet)this.gson.fromJson(arrayString, type);
    }

    @Nullable
    public JsonPrimitive serialize(@Nonnull EnumSet<?> src) {
        Objects.requireNonNull(src, "parameter src cannot be null");
        StringBuilder serializedStringBuilder = new StringBuilder();
        Iterator i = src.iterator();
        while (i.hasNext()) {
            String jsonValue = this.gson.toJson(i.next());
            serializedStringBuilder.append(jsonValue.substring(1, jsonValue.length() - 1));
            if (!i.hasNext()) continue;
            serializedStringBuilder.append(",");
        }
        return new JsonPrimitive(serializedStringBuilder.toString());
    }
}

