/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.SectionGroup;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SectionGroupCollectionPage;
import com.microsoft.graph.requests.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.SectionGroupCollectionResponse;
import com.microsoft.graph.requests.SectionGroupRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SectionGroupCollectionRequest
extends BaseEntityCollectionRequest<SectionGroup, SectionGroupCollectionResponse, SectionGroupCollectionPage> {
    public SectionGroupCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SectionGroupCollectionResponse.class, SectionGroupCollectionPage.class, SectionGroupCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<SectionGroup> postAsync(@Nonnull SectionGroup newSectionGroup) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SectionGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSectionGroup);
    }

    @Override
    @Nonnull
    public SectionGroup post(@Nonnull SectionGroup newSectionGroup) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SectionGroupRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSectionGroup);
    }

    @Nonnull
    public SectionGroupCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SectionGroupCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

