/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.RiskDetection;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.RiskDetectionCollectionPage;
import com.microsoft.graph.requests.RiskDetectionCollectionRequestBuilder;
import com.microsoft.graph.requests.RiskDetectionCollectionResponse;
import com.microsoft.graph.requests.RiskDetectionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RiskDetectionCollectionRequest
extends BaseEntityCollectionRequest<RiskDetection, RiskDetectionCollectionResponse, RiskDetectionCollectionPage> {
    public RiskDetectionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RiskDetectionCollectionResponse.class, RiskDetectionCollectionPage.class, RiskDetectionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<RiskDetection> postAsync(@Nonnull RiskDetection newRiskDetection) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RiskDetectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newRiskDetection);
    }

    @Override
    @Nonnull
    public RiskDetection post(@Nonnull RiskDetection newRiskDetection) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RiskDetectionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newRiskDetection);
    }

    @Nonnull
    public RiskDetectionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public RiskDetectionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

