/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ResourceOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ResourceOperationCollectionPage;
import com.microsoft.graph.requests.ResourceOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.ResourceOperationCollectionResponse;
import com.microsoft.graph.requests.ResourceOperationRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceOperationCollectionRequest
extends BaseEntityCollectionRequest<ResourceOperation, ResourceOperationCollectionResponse, ResourceOperationCollectionPage> {
    public ResourceOperationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceOperationCollectionResponse.class, ResourceOperationCollectionPage.class, ResourceOperationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ResourceOperation> postAsync(@Nonnull ResourceOperation newResourceOperation) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ResourceOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newResourceOperation);
    }

    @Override
    @Nonnull
    public ResourceOperation post(@Nonnull ResourceOperation newResourceOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ResourceOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newResourceOperation);
    }

    @Nonnull
    public ResourceOperationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

