/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ProfilePhotoCollectionPage;
import com.microsoft.graph.requests.ProfilePhotoCollectionRequestBuilder;
import com.microsoft.graph.requests.ProfilePhotoCollectionResponse;
import com.microsoft.graph.requests.ProfilePhotoRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProfilePhotoCollectionRequest
extends BaseEntityCollectionRequest<ProfilePhoto, ProfilePhotoCollectionResponse, ProfilePhotoCollectionPage> {
    public ProfilePhotoCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ProfilePhotoCollectionResponse.class, ProfilePhotoCollectionPage.class, ProfilePhotoCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ProfilePhoto> postAsync(@Nonnull ProfilePhoto newProfilePhoto) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newProfilePhoto);
    }

    @Override
    @Nonnull
    public ProfilePhoto post(@Nonnull ProfilePhoto newProfilePhoto) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newProfilePhoto);
    }

    @Nonnull
    public ProfilePhotoCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ProfilePhotoCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

