/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PrinterShareCollectionResponse;
import com.microsoft.graph.requests.PrinterShareCollectionWithReferencesPage;
import com.microsoft.graph.requests.PrinterShareCollectionWithReferencesRequest;
import com.microsoft.graph.requests.PrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.PrinterShareReferenceRequestBuilder;
import com.microsoft.graph.requests.PrinterShareWithReferenceRequest;
import com.microsoft.graph.requests.PrinterShareWithReferenceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrinterShareCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<PrinterShare, PrinterShareWithReferenceRequest, PrinterShareReferenceRequestBuilder, PrinterShareWithReferenceRequestBuilder, PrinterShareCollectionResponse, PrinterShareCollectionWithReferencesPage, PrinterShareCollectionWithReferencesRequest> {
    public PrinterShareCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterShareCollectionResponse.class, PrinterShareCollectionWithReferencesPage.class, PrinterShareCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<PrinterShare> postAsync(@Nonnull PrinterShare newPrinterShare) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/print/shares/" + newPrinterShare.id);
        return ((PrinterShareWithReferenceRequest)new PrinterShareWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newPrinterShare, body);
    }

    @Override
    @Nonnull
    public PrinterShare post(@Nonnull PrinterShare newPrinterShare) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/print/shares/" + newPrinterShare.id);
        return ((PrinterShareWithReferenceRequest)new PrinterShareWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newPrinterShare, body);
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PrinterShareCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

