/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.PrintService;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PrintServiceCollectionPage;
import com.microsoft.graph.requests.PrintServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintServiceCollectionResponse;
import com.microsoft.graph.requests.PrintServiceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrintServiceCollectionRequest
extends BaseEntityCollectionRequest<PrintService, PrintServiceCollectionResponse, PrintServiceCollectionPage> {
    public PrintServiceCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintServiceCollectionResponse.class, PrintServiceCollectionPage.class, PrintServiceCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<PrintService> postAsync(@Nonnull PrintService newPrintService) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintServiceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPrintService);
    }

    @Override
    @Nonnull
    public PrintService post(@Nonnull PrintService newPrintService) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintServiceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintService);
    }

    @Nonnull
    public PrintServiceCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PrintServiceCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

