/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.PrintDocument;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PrintDocumentCollectionPage;
import com.microsoft.graph.requests.PrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.PrintDocumentCollectionResponse;
import com.microsoft.graph.requests.PrintDocumentRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrintDocumentCollectionRequest
extends BaseEntityCollectionRequest<PrintDocument, PrintDocumentCollectionResponse, PrintDocumentCollectionPage> {
    public PrintDocumentCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintDocumentCollectionResponse.class, PrintDocumentCollectionPage.class, PrintDocumentCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<PrintDocument> postAsync(@Nonnull PrintDocument newPrintDocument) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintDocumentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPrintDocument);
    }

    @Override
    @Nonnull
    public PrintDocument post(@Nonnull PrintDocument newPrintDocument) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintDocumentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintDocument);
    }

    @Nonnull
    public PrintDocumentCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PrintDocumentCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

