/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Post;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PostCollectionPage;
import com.microsoft.graph.requests.PostCollectionRequestBuilder;
import com.microsoft.graph.requests.PostCollectionResponse;
import com.microsoft.graph.requests.PostRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostCollectionRequest
extends BaseEntityCollectionRequest<Post, PostCollectionResponse, PostCollectionPage> {
    public PostCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PostCollectionResponse.class, PostCollectionPage.class, PostCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Post> postAsync(@Nonnull Post newPost) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPost);
    }

    @Override
    @Nonnull
    public Post post(@Nonnull Post newPost) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPost);
    }

    @Nonnull
    public PostCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PostCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PostCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

