/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Person;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PersonCollectionPage;
import com.microsoft.graph.requests.PersonCollectionRequestBuilder;
import com.microsoft.graph.requests.PersonCollectionResponse;
import com.microsoft.graph.requests.PersonRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonCollectionRequest
extends BaseEntityCollectionRequest<Person, PersonCollectionResponse, PersonCollectionPage> {
    public PersonCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PersonCollectionResponse.class, PersonCollectionPage.class, PersonCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Person> postAsync(@Nonnull Person newPerson) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PersonRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPerson);
    }

    @Override
    @Nonnull
    public Person post(@Nonnull Person newPerson) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PersonRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPerson);
    }

    @Nonnull
    public PersonCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PersonCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

