/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Permission;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.PermissionCollectionPage;
import com.microsoft.graph.requests.PermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.PermissionCollectionResponse;
import com.microsoft.graph.requests.PermissionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PermissionCollectionRequest
extends BaseEntityCollectionRequest<Permission, PermissionCollectionResponse, PermissionCollectionPage> {
    public PermissionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PermissionCollectionResponse.class, PermissionCollectionPage.class, PermissionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Permission> postAsync(@Nonnull Permission newPermission) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PermissionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newPermission);
    }

    @Override
    @Nonnull
    public Permission post(@Nonnull Permission newPermission) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PermissionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPermission);
    }

    @Nonnull
    public PermissionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public PermissionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

