/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.OpenShiftChangeRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.OpenShiftChangeRequestCollectionPage;
import com.microsoft.graph.requests.OpenShiftChangeRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.OpenShiftChangeRequestCollectionResponse;
import com.microsoft.graph.requests.OpenShiftChangeRequestRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenShiftChangeRequestCollectionRequest
extends BaseEntityCollectionRequest<OpenShiftChangeRequest, OpenShiftChangeRequestCollectionResponse, OpenShiftChangeRequestCollectionPage> {
    public OpenShiftChangeRequestCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShiftChangeRequestCollectionResponse.class, OpenShiftChangeRequestCollectionPage.class, OpenShiftChangeRequestCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<OpenShiftChangeRequest> postAsync(@Nonnull OpenShiftChangeRequest newOpenShiftChangeRequest) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OpenShiftChangeRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newOpenShiftChangeRequest);
    }

    @Override
    @Nonnull
    public OpenShiftChangeRequest post(@Nonnull OpenShiftChangeRequest newOpenShiftChangeRequest) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OpenShiftChangeRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOpenShiftChangeRequest);
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public OpenShiftChangeRequestCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

