/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.MessageCollectionPage;
import com.microsoft.graph.requests.MessageCollectionRequestBuilder;
import com.microsoft.graph.requests.MessageCollectionResponse;
import com.microsoft.graph.requests.MessageRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageCollectionRequest
extends BaseEntityCollectionRequest<Message, MessageCollectionResponse, MessageCollectionPage> {
    public MessageCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageCollectionResponse.class, MessageCollectionPage.class, MessageCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Message> postAsync(@Nonnull Message newMessage) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newMessage);
    }

    @Override
    @Nonnull
    public Message post(@Nonnull Message newMessage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMessage);
    }

    @Nonnull
    public MessageCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public MessageCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

