/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.ManagedAppPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.ManagedAppPolicyCollectionResponse;
import com.microsoft.graph.requests.ManagedAppPolicyRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ManagedAppPolicyCollectionRequest
extends BaseEntityCollectionRequest<ManagedAppPolicy, ManagedAppPolicyCollectionResponse, ManagedAppPolicyCollectionPage> {
    public ManagedAppPolicyCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppPolicyCollectionResponse.class, ManagedAppPolicyCollectionPage.class, ManagedAppPolicyCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ManagedAppPolicy> postAsync(@Nonnull ManagedAppPolicy newManagedAppPolicy) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newManagedAppPolicy);
    }

    @Override
    @Nonnull
    public ManagedAppPolicy post(@Nonnull ManagedAppPolicy newManagedAppPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppPolicy);
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ManagedAppPolicyCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

