/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Endpoint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.EndpointCollectionPage;
import com.microsoft.graph.requests.EndpointCollectionRequestBuilder;
import com.microsoft.graph.requests.EndpointCollectionResponse;
import com.microsoft.graph.requests.EndpointRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EndpointCollectionRequest
extends BaseEntityCollectionRequest<Endpoint, EndpointCollectionResponse, EndpointCollectionPage> {
    public EndpointCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EndpointCollectionResponse.class, EndpointCollectionPage.class, EndpointCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Endpoint> postAsync(@Nonnull Endpoint newEndpoint) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EndpointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newEndpoint);
    }

    @Override
    @Nonnull
    public Endpoint post(@Nonnull Endpoint newEndpoint) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EndpointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEndpoint);
    }

    @Nonnull
    public EndpointCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public EndpointCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

