/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.EducationClass;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.EducationClassCollectionResponse;
import com.microsoft.graph.requests.EducationClassCollectionWithReferencesPage;
import com.microsoft.graph.requests.EducationClassCollectionWithReferencesRequest;
import com.microsoft.graph.requests.EducationClassCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.EducationClassReferenceRequestBuilder;
import com.microsoft.graph.requests.EducationClassWithReferenceRequest;
import com.microsoft.graph.requests.EducationClassWithReferenceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EducationClassCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<EducationClass, EducationClassWithReferenceRequest, EducationClassReferenceRequestBuilder, EducationClassWithReferenceRequestBuilder, EducationClassCollectionResponse, EducationClassCollectionWithReferencesPage, EducationClassCollectionWithReferencesRequest> {
    public EducationClassCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationClassCollectionResponse.class, EducationClassCollectionWithReferencesPage.class, EducationClassCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<EducationClass> postAsync(@Nonnull EducationClass newEducationClass) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/education/classes/" + newEducationClass.id);
        return ((EducationClassWithReferenceRequest)new EducationClassWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newEducationClass, body);
    }

    @Override
    @Nonnull
    public EducationClass post(@Nonnull EducationClass newEducationClass) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/education/classes/" + newEducationClass.id);
        return ((EducationClassWithReferenceRequest)new EducationClassWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newEducationClass, body);
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public EducationClassCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

