/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.DirectoryObjectCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectCollectionResponse;
import com.microsoft.graph.requests.DirectoryObjectRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryObjectCollectionRequest
extends BaseEntityCollectionRequest<DirectoryObject, DirectoryObjectCollectionResponse, DirectoryObjectCollectionPage> {
    public DirectoryObjectCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectCollectionResponse.class, DirectoryObjectCollectionPage.class, DirectoryObjectCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DirectoryObject> postAsync(@Nonnull DirectoryObject newDirectoryObject) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryObjectRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDirectoryObject);
    }

    @Override
    @Nonnull
    public DirectoryObject post(@Nonnull DirectoryObject newDirectoryObject) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryObjectRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryObject);
    }

    @Nonnull
    public DirectoryObjectCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DirectoryObjectCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

