/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Conversation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ConversationCollectionPage;
import com.microsoft.graph.requests.ConversationCollectionRequestBuilder;
import com.microsoft.graph.requests.ConversationCollectionResponse;
import com.microsoft.graph.requests.ConversationRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConversationCollectionRequest
extends BaseEntityCollectionRequest<Conversation, ConversationCollectionResponse, ConversationCollectionPage> {
    public ConversationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConversationCollectionResponse.class, ConversationCollectionPage.class, ConversationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Conversation> postAsync(@Nonnull Conversation newConversation) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newConversation);
    }

    @Override
    @Nonnull
    public Conversation post(@Nonnull Conversation newConversation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConversation);
    }

    @Nonnull
    public ConversationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ConversationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

