/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Call;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.CallCollectionPage;
import com.microsoft.graph.requests.CallCollectionRequestBuilder;
import com.microsoft.graph.requests.CallCollectionResponse;
import com.microsoft.graph.requests.CallRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CallCollectionRequest
extends BaseEntityCollectionRequest<Call, CallCollectionResponse, CallCollectionPage> {
    public CallCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallCollectionResponse.class, CallCollectionPage.class, CallCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Call> postAsync(@Nonnull Call newCall) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CallRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newCall);
    }

    @Override
    @Nonnull
    public Call post(@Nonnull Call newCall) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CallRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCall);
    }

    @Nonnull
    public CallCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public CallCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public CallCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

