/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.BookingService;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.BookingServiceCollectionPage;
import com.microsoft.graph.requests.BookingServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.BookingServiceCollectionResponse;
import com.microsoft.graph.requests.BookingServiceRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BookingServiceCollectionRequest
extends BaseEntityCollectionRequest<BookingService, BookingServiceCollectionResponse, BookingServiceCollectionPage> {
    public BookingServiceCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingServiceCollectionResponse.class, BookingServiceCollectionPage.class, BookingServiceCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<BookingService> postAsync(@Nonnull BookingService newBookingService) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BookingServiceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newBookingService);
    }

    @Override
    @Nonnull
    public BookingService post(@Nonnull BookingService newBookingService) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BookingServiceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newBookingService);
    }

    @Nonnull
    public BookingServiceCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

