/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AttachmentCollectionPage;
import com.microsoft.graph.requests.AttachmentCollectionRequestBuilder;
import com.microsoft.graph.requests.AttachmentCollectionResponse;
import com.microsoft.graph.requests.AttachmentRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttachmentCollectionRequest
extends BaseEntityCollectionRequest<Attachment, AttachmentCollectionResponse, AttachmentCollectionPage> {
    public AttachmentCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttachmentCollectionResponse.class, AttachmentCollectionPage.class, AttachmentCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Attachment> postAsync(@Nonnull Attachment newAttachment) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AttachmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAttachment);
    }

    @Override
    @Nonnull
    public Attachment post(@Nonnull Attachment newAttachment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AttachmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAttachment);
    }

    @Nonnull
    public AttachmentCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AttachmentCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

