/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Application;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ApplicationCollectionPage;
import com.microsoft.graph.requests.ApplicationCollectionRequestBuilder;
import com.microsoft.graph.requests.ApplicationCollectionResponse;
import com.microsoft.graph.requests.ApplicationRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationCollectionRequest
extends BaseEntityCollectionRequest<Application, ApplicationCollectionResponse, ApplicationCollectionPage> {
    public ApplicationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationCollectionResponse.class, ApplicationCollectionPage.class, ApplicationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Application> postAsync(@Nonnull Application newApplication) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ApplicationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newApplication);
    }

    @Override
    @Nonnull
    public Application post(@Nonnull Application newApplication) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ApplicationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newApplication);
    }

    @Nonnull
    public ApplicationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ApplicationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

