/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Agreement;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AgreementCollectionPage;
import com.microsoft.graph.requests.AgreementCollectionRequestBuilder;
import com.microsoft.graph.requests.AgreementCollectionResponse;
import com.microsoft.graph.requests.AgreementRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AgreementCollectionRequest
extends BaseEntityCollectionRequest<Agreement, AgreementCollectionResponse, AgreementCollectionPage> {
    public AgreementCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementCollectionResponse.class, AgreementCollectionPage.class, AgreementCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Agreement> postAsync(@Nonnull Agreement newAgreement) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AgreementRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAgreement);
    }

    @Override
    @Nonnull
    public Agreement post(@Nonnull Agreement newAgreement) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AgreementRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreement);
    }

    @Nonnull
    public AgreementCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AgreementCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

