/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.microsoft.graph.httpcore.middlewareoption.RedirectOptions;
import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import java.io.IOException;
import java.net.ProtocolException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RedirectHandler
implements Interceptor {
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.REDIRECT;
    private RedirectOptions mRedirectOptions;

    public RedirectHandler() {
        this(null);
    }

    public RedirectHandler(@Nullable RedirectOptions redirectOptions) {
        this.mRedirectOptions = redirectOptions;
        if (redirectOptions == null) {
            this.mRedirectOptions = new RedirectOptions();
        }
    }

    boolean isRedirected(Request request, Response response, int redirectCount, RedirectOptions redirectOptions) throws IOException {
        if (redirectCount > redirectOptions.maxRedirects()) {
            return false;
        }
        String locationHeader = response.header("location");
        if (locationHeader == null) {
            return false;
        }
        int statusCode = response.code();
        return statusCode == 308 || statusCode == 301 || statusCode == 307 || statusCode == 303 || statusCode == 302;
    }

    Request getRedirect(Request request, Response userResponse) throws ProtocolException {
        String location = userResponse.header("Location");
        if (location == null || location.length() == 0) {
            return null;
        }
        if (location.startsWith("/")) {
            if (request.url().toString().endsWith("/")) {
                location = location.substring(1);
            }
            location = request.url() + location;
        }
        HttpUrl requestUrl = userResponse.request().url();
        HttpUrl locationUrl = userResponse.request().url().resolve(location);
        if (locationUrl == null) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        boolean sameScheme = locationUrl.scheme().equalsIgnoreCase(requestUrl.scheme());
        boolean sameHost = locationUrl.host().toString().equalsIgnoreCase(requestUrl.host().toString());
        if (!sameScheme || !sameHost) {
            requestBuilder.removeHeader("Authorization");
        }
        if (userResponse.code() == 303) {
            requestBuilder.method("GET", null);
        }
        return requestBuilder.url(locationUrl).build();
    }

    @Override
    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        TelemetryOptions telemetryOptions = request.tag(TelemetryOptions.class);
        if (telemetryOptions == null) {
            telemetryOptions = new TelemetryOptions();
            request = request.newBuilder().tag(TelemetryOptions.class, telemetryOptions).build();
        }
        telemetryOptions.setFeatureUsage(1);
        Response response = null;
        int requestsCount = 1;
        RedirectOptions redirectOptions = request.tag(RedirectOptions.class);
        redirectOptions = redirectOptions != null ? redirectOptions : this.mRedirectOptions;
        while (true) {
            boolean shouldRedirect;
            boolean bl = shouldRedirect = this.isRedirected(request, response = chain.proceed(request), requestsCount, redirectOptions) && redirectOptions.shouldRedirect().shouldRedirect(response);
            if (!shouldRedirect) break;
            Request followup = this.getRedirect(request, response);
            if (followup == null) continue;
            response.close();
            request = followup;
            ++requestsCount;
        }
        return response;
    }
}

