/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.externalconnectors.models.ConnectionOperation;
import com.microsoft.graph.externalconnectors.requests.ConnectionOperationCollectionPage;
import com.microsoft.graph.externalconnectors.requests.ConnectionOperationCollectionRequestBuilder;
import com.microsoft.graph.externalconnectors.requests.ConnectionOperationCollectionResponse;
import com.microsoft.graph.externalconnectors.requests.ConnectionOperationRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConnectionOperationCollectionRequest
extends BaseEntityCollectionRequest<ConnectionOperation, ConnectionOperationCollectionResponse, ConnectionOperationCollectionPage> {
    public ConnectionOperationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConnectionOperationCollectionResponse.class, ConnectionOperationCollectionPage.class, ConnectionOperationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<ConnectionOperation> postAsync(@Nonnull ConnectionOperation newConnectionOperation) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConnectionOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newConnectionOperation);
    }

    @Override
    @Nonnull
    public ConnectionOperation post(@Nonnull ConnectionOperation newConnectionOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConnectionOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConnectionOperation);
    }

    @Nonnull
    public ConnectionOperationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

