/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.logging.ClientLogger;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import com.microsoft.aad.msal4jextensions.PersistenceSettings;
import com.microsoft.aad.msal4jextensions.PersistenceTokenCacheAccessAspect;
import com.microsoft.aad.msal4jextensions.persistence.linux.KeyRingAccessException;
import com.sun.jna.Platform;
import java.nio.file.Path;
import java.nio.file.Paths;
import reactor.core.publisher.Mono;

public class PersistentTokenCacheImpl
implements ITokenCacheAccessAspect {
    private static final String DEFAULT_CACHE_FILE_NAME = "msal.cache";
    private static final String DEFAULT_CONFIDENTIAL_CACHE_FILE_NAME = "msal.confidential.cache";
    private static final Path DEFAULT_CACHE_FILE_PATH = Platform.isWindows() ? Paths.get(System.getProperty("user.home"), "AppData", "Local", ".IdentityService") : Paths.get(System.getProperty("user.home"), ".IdentityService");
    private static final String DEFAULT_KEYCHAIN_SERVICE = "Microsoft.Developer.IdentityService";
    private static final String DEFAULT_KEYCHAIN_ACCOUNT = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYCHAIN_ACCOUNT = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_NAME = "default";
    private static final String DEFAULT_KEYRING_SCHEMA = "msal.cache";
    private static final String DEFAULT_KEYRING_ITEM_NAME = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYRING_ITEM_NAME = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_ATTR_NAME = "MsalClientID";
    private static final String DEFAULT_KEYRING_ATTR_VALUE = "Microsoft.Developer.IdentityService";
    private static final ClientLogger LOGGER = new ClientLogger(PersistentTokenCacheImpl.class);
    private boolean allowUnencryptedStorage;
    private String name;
    private PersistenceTokenCacheAccessAspect cacheAccessAspect;

    public PersistentTokenCacheImpl setAllowUnencryptedStorage(boolean allowUnencryptedStorage) {
        this.allowUnencryptedStorage = allowUnencryptedStorage;
        return this;
    }

    public PersistentTokenCacheImpl setName(String name) {
        this.name = name;
        return this;
    }

    Mono<Boolean> registerCache() {
        return Mono.defer(() -> {
            try {
                PersistenceSettings persistenceSettings = this.getPersistenceSettings();
                this.cacheAccessAspect = new PersistenceTokenCacheAccessAspect(persistenceSettings);
                return Mono.just(true);
            }
            catch (Throwable t) {
                return Mono.error(LOGGER.logExceptionAsError(new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, t)));
            }
        });
    }

    @Override
    public void beforeCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.cacheAccessAspect.beforeCacheAccess(iTokenCacheAccessContext);
    }

    @Override
    public void afterCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.cacheAccessAspect.afterCacheAccess(iTokenCacheAccessContext);
    }

    private PersistenceSettings getPersistenceSettings() {
        PersistenceSettings.Builder persistenceSettingsBuilder = PersistenceSettings.builder(this.name != null ? this.name : "msal.cache", DEFAULT_CACHE_FILE_PATH);
        if (Platform.isMac()) {
            persistenceSettingsBuilder.setMacKeychain("Microsoft.Developer.IdentityService", this.name != null ? this.name : "MSALCache");
            return persistenceSettingsBuilder.build();
        }
        if (Platform.isLinux()) {
            try {
                persistenceSettingsBuilder.setLinuxKeyring(DEFAULT_KEYRING_NAME, "msal.cache", this.name != null ? this.name : "MSALCache", DEFAULT_KEYRING_ATTR_NAME, "Microsoft.Developer.IdentityService", null, null);
                return persistenceSettingsBuilder.build();
            }
            catch (KeyRingAccessException e) {
                if (!this.allowUnencryptedStorage) {
                    throw LOGGER.logExceptionAsError(e);
                }
                persistenceSettingsBuilder.setLinuxUseUnprotectedFileAsCacheStorage(true);
                return persistenceSettingsBuilder.build();
            }
        }
        return persistenceSettingsBuilder.build();
    }
}

