/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IntelliJAuthMethodDetails;
import com.azure.identity.implementation.LinuxKeyRingAccessor;
import com.azure.identity.implementation.intellij.IntelliJKdbxDatabase;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IntelliJCacheAccessor {
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJCacheAccessor.class);
    private final String keePassDatabasePath;
    private static final byte[] CRYPTO_KEY = new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99};
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private static final ObjectMapper DONT_FAIL_ON_UNKNOWN_PROPERTIES_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public IntelliJCacheAccessor(String keePassDatabasePath) {
        this.keePassDatabasePath = keePassDatabasePath;
    }

    private List<String> getAzureToolsForIntelliJPluginConfigPaths() {
        return Arrays.asList(Paths.get(System.getProperty("user.home"), "AzureToolsForIntelliJ").toString(), Paths.get(System.getProperty("user.home"), ".AzureToolsForIntelliJ").toString());
    }

    public JsonNode getDeviceCodeCredentials() throws IOException {
        if (Platform.isMac()) {
            KeyChainAccessor accessor = new KeyChainAccessor(null, "ADAuthManager", "cachedAuthResult");
            String jsonCred = new String(accessor.read(), StandardCharsets.UTF_8);
            return DEFAULT_MAPPER.readTree(jsonCred);
        }
        if (Platform.isLinux()) {
            LinuxKeyRingAccessor accessor = new LinuxKeyRingAccessor("com.intellij.credentialStore.Credential", "service", "ADAuthManager", "account", "cachedAuthResult");
            String jsonCred = new String(accessor.read(), StandardCharsets.UTF_8);
            if (jsonCred.startsWith("cachedAuthResult@")) {
                jsonCred = jsonCred.substring("cachedAuthResult@".length());
            }
            return DEFAULT_MAPPER.readTree(jsonCred);
        }
        if (Platform.isWindows()) {
            return this.getCredentialFromKdbx();
        }
        throw LOGGER.logExceptionAsError(new RuntimeException(String.format("OS %s Platform not supported.", Platform.getOSType())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getIntellijServicePrincipalDetails(String credFilePath) throws IOException {
        HashMap<String, String> servicePrincipalDetails = new HashMap<String, String>(8);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(credFilePath));
            String line = reader.readLine();
            while (line != null) {
                String[] split2 = line.split("=");
                split2[1] = split2[1].replace("\\", "");
                servicePrincipalDetails.put(split2[0], split2[1]);
                line = reader.readLine();
            }
        }
        return servicePrincipalDetails;
    }

    private JsonNode getCredentialFromKdbx() throws IOException {
        JsonNode jsonNode;
        String password;
        if (CoreUtils.isNullOrEmpty(this.keePassDatabasePath)) {
            throw new CredentialUnavailableException("The KeePass database path is either empty or not configured. Please configure it on the builder. It is required to use IntelliJ credential on the windows platform.");
        }
        String extractedpwd = this.getKdbxPassword();
        SecretKeySpec key = new SecretKeySpec(CRYPTO_KEY, "AES");
        byte[] dataToDecrypt = Crypt32Util.cryptUnprotectData(Base64.getDecoder().decode(extractedpwd));
        ByteBuffer decryptBuffer = ByteBuffer.wrap(dataToDecrypt);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int ivLen = decryptBuffer.getInt();
            cipher.init(2, (Key)key, new IvParameterSpec(dataToDecrypt, decryptBuffer.position(), ivLen));
            int dataOffset = decryptBuffer.position() + ivLen;
            byte[] decrypted = cipher.doFinal(dataToDecrypt, dataOffset, dataToDecrypt.length - dataOffset);
            password = new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Unable to access cache.", e));
        }
        FileInputStream inputStream2 = new FileInputStream(this.keePassDatabasePath);
        try {
            IntelliJKdbxDatabase kdbxDatabase = IntelliJKdbxDatabase.parse(inputStream2, password);
            String jsonToken = kdbxDatabase.getDatabaseEntryValue("ADAuthManager");
            if (CoreUtils.isNullOrEmpty(jsonToken)) {
                throw new CredentialUnavailableException("No credentials found in the cache. Please login with IntelliJ Azure Tools plugin in the IDE.");
            }
            jsonNode = DEFAULT_MAPPER.readTree(jsonToken);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to read KeePass database.", e));
            }
        }
        ((InputStream)inputStream2).close();
        return jsonNode;
    }

    private String getKdbxPassword() throws IOException {
        String passwordFilePath = new File(this.keePassDatabasePath).getParent() + File.separator + "c.pwd";
        String extractedpwd = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(passwordFilePath));){
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("value")) {
                    String[] tokens = line.split(" ");
                    if (tokens.length == 3) {
                        extractedpwd = tokens[2];
                        break;
                    }
                    throw LOGGER.logExceptionAsError(new RuntimeException("Password not found in the file."));
                }
                line = reader.readLine();
            }
        }
        return extractedpwd;
    }

    public String getAzureAuthHost(String azureEnvironment) {
        switch (azureEnvironment) {
            case "GLOBAL": {
                return "https://login.microsoftonline.com/";
            }
            case "CHINA": {
                return "https://login.chinacloudapi.cn/";
            }
            case "GERMAN": {
                return "https://login.microsoftonline.de/";
            }
            case "US_GOVERNMENT": {
                return "https://login.microsoftonline.us/";
            }
        }
        return "https://login.microsoftonline.com/";
    }

    public IntelliJAuthMethodDetails parseAuthMethodDetails(File file) throws IOException {
        return (IntelliJAuthMethodDetails)DONT_FAIL_ON_UNKNOWN_PROPERTIES_MAPPER.readValue(file, IntelliJAuthMethodDetails.class);
    }

    public IntelliJAuthMethodDetails getAuthDetailsIfAvailable() throws IOException {
        String metadataPath;
        String authMethodDetailsPath;
        File authFile = null;
        Iterator<String> iterator = this.getAzureToolsForIntelliJPluginConfigPaths().iterator();
        while (iterator.hasNext() && !(authFile = new File(authMethodDetailsPath = Paths.get(metadataPath = iterator.next(), "AuthMethodDetails.json").toString())).exists()) {
        }
        if (authFile == null || !authFile.exists()) {
            return null;
        }
        IntelliJAuthMethodDetails authMethodDetails = this.parseAuthMethodDetails(authFile);
        String authType = authMethodDetails.getAuthMethod();
        if (CoreUtils.isNullOrEmpty(authType)) {
            return null;
        }
        if ("SP".equalsIgnoreCase(authType) ? CoreUtils.isNullOrEmpty(authMethodDetails.getCredFilePath()) : "DC".equalsIgnoreCase(authType) && CoreUtils.isNullOrEmpty(authMethodDetails.getAccountEmail())) {
            return null;
        }
        return authMethodDetails;
    }
}

