/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class ClientAssertionCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ClientAssertionCredential.class);
    private final IdentityClient identityClient;

    ClientAssertionCredential(String clientId, String tenantId, Supplier<String> clientAssertion, IdentityClientOptions identityClientOptions) {
        this.identityClient = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).clientAssertionSupplier(clientAssertion).identityClientOptions(identityClientOptions).build();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithConfidentialClient(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }
}

