/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.implementation.PollingUtils;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class OperationResourcePollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final String DEFAULT_OPERATION_LOCATION_HEADER = "Operation-Location";
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final String operationLocationHeaderName;
    private final Context context;

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline) {
        this(httpPipeline, new DefaultJsonSerializer(), DEFAULT_OPERATION_LOCATION_HEADER, Context.NONE);
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, String operationLocationHeaderName) {
        this(httpPipeline, serializer, operationLocationHeaderName, Context.NONE);
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, String operationLocationHeaderName, Context context) {
        this.httpPipeline = Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null");
        this.serializer = serializer != null ? serializer : new DefaultJsonSerializer();
        this.operationLocationHeaderName = operationLocationHeaderName != null ? operationLocationHeaderName : DEFAULT_OPERATION_LOCATION_HEADER;
        this.context = context;
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        HttpHeader operationLocationHeader = initialResponse.getHeaders().get(this.operationLocationHeaderName);
        if (operationLocationHeader != null) {
            try {
                new URL(operationLocationHeader.getValue());
                return Mono.just(true);
            }
            catch (MalformedURLException e) {
                return Mono.just(false);
            }
        }
        return Mono.just(false);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader operationLocationHeader = response.getHeaders().get(this.operationLocationHeaderName);
        HttpHeader locationHeader = response.getHeaders().get("Location");
        if (operationLocationHeader != null) {
            pollingContext.setData(this.operationLocationHeaderName, operationLocationHeader.getValue());
        }
        if (locationHeader != null) {
            pollingContext.setData("Location", locationHeader.getValue());
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            String retryAfterValue = response.getHeaders().getValue("Retry-After");
            Duration retryAfter = retryAfterValue == null ? null : Duration.ofSeconds(Long.parseLong(retryAfterValue));
            return PollingUtils.convertResponse(response.getValue(), this.serializer, pollResponseType).map(value -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, value, retryAfter)).switchIfEmpty(Mono.defer(() -> Mono.just(new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, null, retryAfter))));
        }
        return Mono.error(new AzureException(String.format("Operation failed or cancelled with status code %d,, '%s' header: %s, and response body: %s", response.getStatusCode(), this.operationLocationHeaderName, operationLocationHeader, PollingUtils.serializeResponse(response.getValue(), this.serializer))));
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpRequest request = new HttpRequest(HttpMethod.GET, pollingContext.getData(this.operationLocationHeaderName));
        return this.httpPipeline.send(request, this.context).flatMap(response -> response.getBodyAsByteArray().map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, new TypeReference<PollResult>(){}).map(pollResult -> {
            if (pollResult.getResourceLocation() != null) {
                pollingContext.setData("resourceLocation", pollResult.getResourceLocation());
            }
            pollingContext.setData("pollResponseBody", binaryData.toString());
            return pollResult.getStatus();
        }).flatMap(status -> {
            String retryAfterValue = response.getHeaders().getValue("Retry-After");
            Duration retryAfter = retryAfterValue == null ? null : Duration.ofSeconds(Long.parseLong(retryAfterValue));
            return PollingUtils.deserializeResponse(binaryData, this.serializer, pollResponseType).map(value -> new PollResponse<Object>((LongRunningOperationStatus)status, value, retryAfter));
        })));
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.error(new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            return Mono.error(new AzureException("Long running operation cancelled."));
        }
        String finalGetUrl = pollingContext.getData("resourceLocation");
        if (finalGetUrl == null) {
            String httpMethod = pollingContext.getData("httpMethod");
            if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
                finalGetUrl = pollingContext.getData("requestURL");
            } else if (HttpMethod.POST.name().equalsIgnoreCase(httpMethod) && pollingContext.getData("Location") != null) {
                finalGetUrl = pollingContext.getData("Location");
            } else {
                return Mono.error(new AzureException("Cannot get final result"));
            }
        }
        if (finalGetUrl == null) {
            String latestResponseBody = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponse(BinaryData.fromString(latestResponseBody), this.serializer, resultType);
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, finalGetUrl);
        return this.httpPipeline.send(request, this.context).flatMap(HttpResponse::getBodyAsByteArray).map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, resultType));
    }

    private static class PollResult {
        private LongRunningOperationStatus status;
        private String resourceLocation;

        private PollResult() {
        }

        public LongRunningOperationStatus getStatus() {
            return this.status;
        }

        @JsonSetter
        public PollResult setStatus(String status) {
            this.status = "NotStarted".equalsIgnoreCase(status) ? LongRunningOperationStatus.NOT_STARTED : ("InProgress".equalsIgnoreCase(status) || "Running".equalsIgnoreCase(status) ? LongRunningOperationStatus.IN_PROGRESS : ("Succeeded".equalsIgnoreCase(status) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : ("Failed".equalsIgnoreCase(status) ? LongRunningOperationStatus.FAILED : LongRunningOperationStatus.fromString(status, true))));
            return this;
        }

        public PollResult setStatus(LongRunningOperationStatus status) {
            this.status = status;
            return this;
        }

        public String getResourceLocation() {
            return this.resourceLocation;
        }

        public PollResult setResourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            return this;
        }
    }
}

