/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.implementation.PollContextRequiredException;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class DefaultSyncPoller<T, U>
implements SyncPoller<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultSyncPoller.class);
    private final Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final PollResponse<T> activationResponse;
    private final PollingContext<T> pollingContext = new PollingContext();
    private volatile PollingContext<T> terminalPollContext;
    private volatile Duration pollInterval;

    DefaultSyncPoller(Duration pollInterval, Function<PollingContext<T>, PollResponse<T>> syncActivationOperation, Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation, Function<PollingContext<T>, Mono<U>> fetchResultOperation) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.isNegative() || pollInterval.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        Objects.requireNonNull(syncActivationOperation, "'syncActivationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(pollOperation, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(cancelOperation, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(fetchResultOperation, "'fetchResultOperation' cannot be null.");
        this.activationResponse = syncActivationOperation.apply(this.pollingContext);
        this.pollingContext.setOnetimeActivationResponse(this.activationResponse);
        this.pollingContext.setLatestResponse(this.activationResponse);
        if (this.activationResponse.getStatus().isComplete()) {
            this.terminalPollContext = this.pollingContext;
        }
    }

    @Override
    public PollResponse<T> poll() {
        PollResponse<T> response = this.pollOperation.apply(this.pollingContext).block();
        this.pollingContext.setLatestResponse(response);
        if (response.getStatus().isComplete()) {
            this.terminalPollContext = this.pollingContext.copy();
        }
        return response;
    }

    @Override
    public PollResponse<T> waitForCompletion() {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        AsyncPollResponse<T, U> finalAsyncPollResponse = this.pollingLoop(context).blockLast();
        PollResponse<T> response = DefaultSyncPoller.toPollResponse(finalAsyncPollResponse);
        this.terminalPollContext = context;
        return response;
    }

    @Override
    public PollResponse<T> waitForCompletion(Duration timeout2) {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        AsyncPollResponse<T, U> finalAsyncPollResponse = this.pollingLoop(context).timeout(timeout2).blockLast();
        PollResponse<T> response = DefaultSyncPoller.toPollResponse(finalAsyncPollResponse);
        this.terminalPollContext = context;
        return response;
    }

    @Override
    public PollResponse<T> waitUntil(LongRunningOperationStatus statusToWaitFor) {
        Objects.requireNonNull(statusToWaitFor, "'statusToWaitFor' cannot be null.");
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null && currentTerminalPollContext.getLatestResponse().getStatus() == statusToWaitFor) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        AsyncPollResponse asyncPollResponse = this.pollingLoop(context).takeUntil(apr -> this.matchStatus((AsyncPollResponse<T, U>)apr, statusToWaitFor)).last().switchIfEmpty(Mono.defer(() -> Mono.error(new NoSuchElementException("Polling completed without receiving the given status '" + statusToWaitFor + "'.")))).block();
        PollResponse<T> response = DefaultSyncPoller.toPollResponse(asyncPollResponse);
        if (response.getStatus().isComplete()) {
            this.terminalPollContext = context;
        }
        return response;
    }

    @Override
    public PollResponse<T> waitUntil(Duration timeout2, LongRunningOperationStatus statusToWaitFor) {
        Objects.requireNonNull(timeout2, "'timeout' cannot be null.");
        if (timeout2.isNegative() || timeout2.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for timeout is not allowed."));
        }
        Objects.requireNonNull(statusToWaitFor, "'statusToWaitFor' cannot be null.");
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null && currentTerminalPollContext.getLatestResponse().getStatus() == statusToWaitFor) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        AsyncPollResponse asyncPollResponse = this.pollingLoop(context).takeUntil(apr -> this.matchStatus((AsyncPollResponse<T, U>)apr, statusToWaitFor)).last().timeout(timeout2).switchIfEmpty(Mono.defer(() -> Mono.error(new NoSuchElementException("Polling completed without receiving the given status '" + statusToWaitFor + "'.")))).block();
        PollResponse<T> response = DefaultSyncPoller.toPollResponse(asyncPollResponse);
        if (response.getStatus().isComplete()) {
            this.terminalPollContext = context;
        }
        return response;
    }

    @Override
    public U getFinalResult() {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return this.fetchResultOperation.apply(currentTerminalPollContext).block();
        }
        PollingContext<T> context = this.pollingContext.copy();
        AsyncPollResponse<T, U> finalAsyncPollResponse = this.pollingLoop(context).blockLast();
        this.terminalPollContext = context;
        return finalAsyncPollResponse.getFinalResult().block();
    }

    @Override
    public void cancelOperation() {
        PollingContext<T> context1 = this.pollingContext.copy();
        if (context1.getActivationResponse() == context1.getLatestResponse()) {
            this.cancelOperation.apply(context1, context1.getActivationResponse()).block();
        } else {
            try {
                this.cancelOperation.apply(null, this.activationResponse).block();
            }
            catch (PollContextRequiredException crp) {
                PollingContext<T> context2 = this.pollingContext.copy();
                this.pollingLoop(context2).next().block();
                this.cancelOperation.apply(context2, this.activationResponse).block();
            }
        }
    }

    @Override
    public SyncPoller<T, U> setPollInterval(Duration pollInterval) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.isNegative() || pollInterval.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'pollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        return this;
    }

    private static <T, U> PollResponse<T> toPollResponse(AsyncPollResponse<T, U> asyncPollResponse) {
        return new PollResponse<T>(asyncPollResponse.getStatus(), asyncPollResponse.getValue(), asyncPollResponse.getRetryAfter());
    }

    private boolean matchStatus(AsyncPollResponse<T, U> currentPollResponse, LongRunningOperationStatus statusToWaitFor) {
        if (currentPollResponse == null || statusToWaitFor == null) {
            return false;
        }
        return statusToWaitFor == currentPollResponse.getStatus();
    }

    private Flux<AsyncPollResponse<T, U>> pollingLoop(PollingContext<T> pollingContext) {
        return Flux.using(() -> pollingContext, cxt -> Mono.defer(() -> this.pollOperation.apply((PollingContext<PollingContext>)cxt)).delaySubscription(this.getDelay(cxt.getLatestResponse())).switchIfEmpty(Mono.defer(() -> Mono.error(new IllegalStateException("PollOperation returned Mono.empty().")))).repeat().takeUntil(currentPollResponse -> currentPollResponse.getStatus().isComplete()).concatMap(currentPollResponse -> {
            cxt.setLatestResponse(currentPollResponse);
            return Mono.just(new AsyncPollResponse<T, U>(cxt, this.cancelOperation, this.fetchResultOperation));
        }), cxt -> {});
    }

    private Duration getDelay(PollResponse<T> pollResponse) {
        Duration retryAfter = pollResponse.getRetryAfter();
        if (retryAfter == null) {
            return this.pollInterval;
        }
        return retryAfter.compareTo(Duration.ZERO) > 0 ? retryAfter : this.pollInterval;
    }
}

