/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.CleanableReference;
import com.azure.core.util.ReferenceManager;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;

public final class ReferenceManagerImpl
implements ReferenceManager {
    private static final ClientLogger LOGGER = new ClientLogger(ReferenceManagerImpl.class);
    private static final String BASE_THREAD_NAME = "azure-sdk-referencemanager";
    private final CleanableReference<?> cleanableReferenceList;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public ReferenceManagerImpl() {
        this.cleanableReferenceList = new CleanableReference();
        Thread thread = new Thread(this::clearReferenceQueue, BASE_THREAD_NAME);
        new CleanableReference<ReferenceManagerImpl>(this, () -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.WARNING, () -> "Failed to shutdown ReferenceManager thread.", e);
            }
        }, this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void register(Object object, Runnable cleanupAction) {
        new CleanableReference<Object>(Objects.requireNonNull(object, "'object' cannot be null."), Objects.requireNonNull(cleanupAction, "'cleanupAction' cannot be null."), this);
    }

    void clearReferenceQueue() {
        while (this.cleanableReferenceList.hasRemaining()) {
            CleanableReference reference = null;
            try {
                reference = (CleanableReference)this.queue.remove(30000L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(LogLevel.VERBOSE, () -> "ReferenceManager Thread interrupted while waiting for a reference to clean.", ex);
            }
            try {
                if (reference == null) continue;
                reference.clean();
            }
            catch (Exception ex) {
                LOGGER.log(LogLevel.INFORMATIONAL, () -> "Cleaning a reference threw an exception.", ex);
            }
        }
    }

    static int getJavaImplementationMajorVersion() {
        return 8;
    }

    ReferenceQueue<Object> getQueue() {
        return this.queue;
    }

    CleanableReference<?> getCleanableReferenceList() {
        return this.cleanableReferenceList;
    }
}

