/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public final class FileContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(FileContent.class);
    private final Path file;
    private final int chunkSize;
    private final long length;
    private final AtomicReference<byte[]> bytes = new AtomicReference();

    public FileContent(Path file, int chunkSize) {
        Objects.requireNonNull(file, "'file' cannot be null.");
        if (chunkSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'chunkSize' cannot be less than or equal to 0."));
        }
        this.file = file;
        this.chunkSize = chunkSize;
        if (!file.toFile().exists()) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(new FileNotFoundException("File does not exist " + file)));
        }
        this.length = file.toFile().length();
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        byte[] data = this.bytes.get();
        if (data == null) {
            this.bytes.set(this.getBytes());
            data = this.bytes.get();
        }
        return data;
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserialize(this.toStream(), typeReference);
    }

    @Override
    public InputStream toStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file.toFile()), this.chunkSize);
        }
        catch (FileNotFoundException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException("File not found " + this.file, e));
        }
    }

    @Override
    public ByteBuffer toByteBuffer() {
        try {
            FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);
            return fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
        }
        catch (IOException exception) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(exception));
        }
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return Flux.using(() -> FileChannel.open(this.file, new OpenOption[0]), channel -> Flux.generate(() -> 0, (count, sink2) -> {
            if ((long)count.intValue() == this.length) {
                sink2.complete();
                return count;
            }
            int readCount = (int)Math.min((long)this.chunkSize, this.length - (long)count.intValue());
            try {
                sink2.next(channel.map(FileChannel.MapMode.READ_ONLY, count.intValue(), readCount));
            }
            catch (IOException ex) {
                sink2.error(ex);
            }
            return count + readCount;
        }), channel -> {
            try {
                channel.close();
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate(ex));
            }
        });
    }

    private byte[] getBytes() {
        try {
            return Files.readAllBytes(this.file);
        }
        catch (IOException exception) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(exception));
        }
    }
}

