/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.net.MalformedURLException;
import reactor.core.publisher.Mono;

public class ProtocolPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(ProtocolPolicy.class);
    private final String protocol;
    private final boolean overwrite;

    public ProtocolPolicy(String protocol, boolean overwrite) {
        this.protocol = protocol;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        UrlBuilder urlBuilder = UrlBuilder.parse(context.getHttpRequest().getUrl());
        if (this.overwrite || urlBuilder.getScheme() == null) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Setting protocol to " + this.protocol);
            try {
                context.getHttpRequest().setUrl(urlBuilder.setScheme(this.protocol).toUrl());
            }
            catch (MalformedURLException e) {
                return Mono.error(new RuntimeException("Failed to set the HTTP request protocol to " + this.protocol + ".", e));
            }
        }
        return next.process();
    }
}

