/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.ldap.importation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.ListResult;
import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.core.commons.gwt.JsMapStringString;
import net.bluemind.domain.api.gwt.js.JsDomain;
import net.bluemind.gwtconsoleapp.base.editor.Ajax;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.ProgressDialogPanel;
import net.bluemind.gwtconsoleapp.base.handler.DefaultAsyncHandler;
import net.bluemind.gwtconsoleapp.base.notification.Notification;
import net.bluemind.scheduledjob.api.JobExecution;
import net.bluemind.scheduledjob.api.JobExecutionQuery;
import net.bluemind.scheduledjob.api.JobExitStatus;
import net.bluemind.scheduledjob.api.gwt.endpoint.JobGwtEndpoint;
import net.bluemind.system.ldap.importation.api.LdapProperties;
import net.bluemind.system.ldap.importation.api.gwt.endpoint.LdapImportGwtEndpoint;
import net.bluemind.ui.adminconsole.base.Actions;
import net.bluemind.ui.adminconsole.ldap.importation.JobStatusPanel;
import net.bluemind.ui.adminconsole.ldap.importation.l10n.Ldap;
import net.bluemind.ui.adminconsole.system.domains.DomainKeys;
import net.bluemind.ui.common.client.forms.PasswordEdit;

public class EditDomainLdapEditor
extends CompositeGwtWidgetElement {
    static final String TYPE = "bm.ac.EditDomainLdapEditor";
    private static EditDomainLdapUiBinder uiBinder = (EditDomainLdapUiBinder)GWT.create(EditDomainLdapUiBinder.class);
    @UiField
    CheckBox ldapImportEnabled;
    @UiField
    TextBox ldapHostname;
    @UiField
    ListBox ldapProtocol;
    @UiField
    TextBox ldapBaseDn;
    @UiField
    TextBox ldapLoginDn;
    @UiField
    PasswordEdit ldapLoginPw;
    @UiField
    TextBox ldapUserFilter;
    @UiField
    TextBox ldapGroupFilter;
    @UiField
    TextBox ldapExternalId;
    @UiField
    TextBox ldapSplitDomainGroup;
    @UiField
    Button ldapConnTest;
    @UiField
    Button ldapStartGlobal;
    @UiField
    Button ldapStartIncremental;
    @UiField
    JobStatusPanel lastSyncSuccessful;
    @UiField
    JobStatusPanel lastSyncStatus;
    private List<TextBox> ldapPropertiesTextBox = new ArrayList<TextBox>();
    private List<Button> disableOnChange = new ArrayList<Button>();
    private List<Button> ldapJobActionsButtons = new ArrayList<Button>();
    private String domainName;
    private String domainUid;
    private boolean propertiesChanged = false;

    protected EditDomainLdapEditor() {
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        this.initWidget((Widget)hTMLPanel);
        this.ldapPropertiesTextBox.addAll(Arrays.asList(this.ldapHostname, this.ldapBaseDn, this.ldapLoginDn, this.ldapLoginPw, this.ldapUserFilter, this.ldapGroupFilter, this.ldapExternalId, this.ldapSplitDomainGroup));
        this.disableOnChange.addAll(Arrays.asList(this.ldapStartGlobal, this.ldapStartIncremental));
        if (Ajax.TOKEN.isDomainGlobal()) {
            this.ldapJobActionsButtons.addAll(Arrays.asList(this.ldapStartGlobal, this.ldapStartIncremental));
            this.addLdapPropertiesChangeHandlers();
        } else {
            this.ldapJobActionsButtons.addAll(Arrays.asList(this.ldapStartIncremental));
            this.ldapStartGlobal.setVisible(false);
        }
        this.displayLastSyncStatus();
    }

    private void addLdapPropertiesChangeHandlers() {
        for (TextBox textBox : this.ldapPropertiesTextBox) {
            textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> valueChangeEvent) {
                    EditDomainLdapEditor.this.propertiesChanged();
                }
            });
        }
        this.ldapProtocol.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent changeEvent) {
                EditDomainLdapEditor.this.propertiesChanged();
            }
        });
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        JsMapStringJsObject jsMapStringJsObject = (JsMapStringJsObject)javaScriptObject.cast();
        JsDomain jsDomain = (JsDomain)jsMapStringJsObject.get(DomainKeys.domain.name()).cast();
        this.domainName = jsDomain.getName();
        this.domainUid = jsMapStringJsObject.getString(DomainKeys.domainUid.name());
        Boolean bl = Boolean.valueOf(jsDomain.getProperties().get(LdapProperties.import_ldap_enabled.name()));
        this.ldapImportEnabled.setValue(bl);
        this.enableLdapProperties(bl);
        this.ldapHostname.setValue((Object)jsDomain.getProperties().get(LdapProperties.import_ldap_hostname.name()));
        this.loadProtocol(jsDomain.getProperties().get(LdapProperties.import_ldap_protocol.name()), Boolean.valueOf(jsDomain.getProperties().get(LdapProperties.import_ldap_accept_certificate.name())));
        this.ldapBaseDn.setValue((Object)jsDomain.getProperties().get(LdapProperties.import_ldap_base_dn.name()));
        this.ldapLoginDn.setValue((Object)jsDomain.getProperties().get(LdapProperties.import_ldap_login_dn.name()));
        this.ldapLoginPw.setValue(jsDomain.getProperties().get(LdapProperties.import_ldap_password.name()));
        String string = jsDomain.getProperties().get(LdapProperties.import_ldap_user_filter.name());
        if (string == null || string.trim().isEmpty()) {
            string = LdapProperties.import_ldap_user_filter.getDefaultValue();
        }
        this.ldapUserFilter.setValue((Object)string);
        string = jsDomain.getProperties().get(LdapProperties.import_ldap_group_filter.name());
        if (string == null || string.trim().isEmpty()) {
            string = LdapProperties.import_ldap_group_filter.getDefaultValue();
        }
        this.ldapGroupFilter.setValue((Object)string);
        this.ldapExternalId.setValue((Object)jsDomain.getProperties().get(LdapProperties.import_ldap_ext_id_attribute.name()));
        this.ldapSplitDomainGroup.setValue((Object)jsDomain.getProperties().get(LdapProperties.import_ldap_relay_mailbox_group.name()));
    }

    private void loadProtocol(String string, boolean bl) {
        if (string == null) {
            string = "plain";
        }
        switch (string.toLowerCase()) {
            case "ssl": {
                if (bl) {
                    this.ldapProtocol.setSelectedIndex(4);
                    break;
                }
                this.ldapProtocol.setSelectedIndex(3);
                break;
            }
            case "tls": {
                if (bl) {
                    this.ldapProtocol.setSelectedIndex(2);
                    break;
                }
                this.ldapProtocol.setSelectedIndex(1);
                break;
            }
            default: {
                this.ldapProtocol.setSelectedIndex(0);
            }
        }
    }

    private String ldapProtocol() {
        if (this.ldapProtocol.getSelectedValue() == null) {
            return "plain";
        }
        if (this.ldapProtocol.getSelectedValue().startsWith("tls")) {
            return "tls";
        }
        if (this.ldapProtocol.getSelectedValue().startsWith("ssl")) {
            return "ssl";
        }
        return "plain";
    }

    private String ldapAllCertificate() {
        if (this.ldapProtocol.getSelectedValue() != null && this.ldapProtocol.getSelectedValue().endsWith("AllCert")) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
        JsMapStringJsObject jsMapStringJsObject = (JsMapStringJsObject)javaScriptObject.cast();
        JsDomain jsDomain = (JsDomain)jsMapStringJsObject.get(DomainKeys.domain.name()).cast();
        JsMapStringString jsMapStringString = jsDomain.getProperties();
        jsMapStringString.put(LdapProperties.import_ldap_enabled.name(), this.ldapImportEnabled.getValue().toString());
        jsMapStringString.put(LdapProperties.import_ldap_hostname.name(), this.ldapHostname.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_protocol.name(), this.ldapProtocol());
        jsMapStringString.put(LdapProperties.import_ldap_accept_certificate.name(), this.ldapAllCertificate());
        jsMapStringString.put(LdapProperties.import_ldap_base_dn.name(), this.ldapBaseDn.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_login_dn.name(), this.ldapLoginDn.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_password.name(), this.ldapLoginPw.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_user_filter.name(), this.ldapUserFilter.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_group_filter.name(), this.ldapGroupFilter.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_ext_id_attribute.name(), this.ldapExternalId.getValue());
        jsMapStringString.put(LdapProperties.import_ldap_relay_mailbox_group.name(), this.ldapSplitDomainGroup.getValue());
    }

    public static void registerType() {
        GwtWidgetElement.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                return new EditDomainLdapEditor();
            }
        });
    }

    @UiHandler(value={"ldapImportEnabled"})
    void ldapImportChangeHandler(ClickEvent clickEvent) {
        this.enableLdapProperties(((CheckBox)clickEvent.getSource()).getValue());
    }

    @UiHandler(value={"ldapConnTest"})
    void ldapConnTestClickHandler(ClickEvent clickEvent) {
        final ProgressDialogPanel progressDialogPanel = new ProgressDialogPanel();
        progressDialogPanel.setText("Testing...");
        progressDialogPanel.center();
        progressDialogPanel.show();
        new LdapImportGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).testParameters(this.ldapHostname.getValue(), this.ldapProtocol(), this.ldapAllCertificate(), this.ldapBaseDn.getValue(), this.ldapLoginDn.getValue(), this.ldapLoginPw.getValue(), this.ldapUserFilter.getValue(), this.ldapGroupFilter.getValue(), (AsyncHandler)new DefaultAsyncHandler<Void>(){

            public void failure(Throwable throwable) {
                progressDialogPanel.hide();
                Notification.get().reportError(String.valueOf(Ldap.INST.fail()) + ": " + throwable.getMessage());
            }

            public void success(Void void_) {
                progressDialogPanel.hide();
                Notification.get().reportInfo(Ldap.INST.testSuccess());
            }
        });
    }

    @UiHandler(value={"ldapStartIncremental"})
    void ldapStartIncrementalClickHandler(ClickEvent clickEvent) {
        new JobGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).start("net.bluemind.system.ldap.importation.ImportLDAPjob", this.domainName, (AsyncHandler)new AsyncHandler<Void>(){

            public void success(Void void_) {
                Notification.get().reportInfo(Ldap.INST.incrementalStartSuccess());
            }

            public void failure(Throwable throwable) {
                Notification.get().reportError(Ldap.INST.incrementalStartFail());
            }
        });
    }

    @UiHandler(value={"ldapStartGlobal"})
    void ldapStartGlobalClickHandler(ClickEvent clickEvent) {
        new LdapImportGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).fullSync(this.domainUid, (AsyncHandler)new AsyncHandler<Void>(){

            public void success(Void void_) {
                Notification.get().reportInfo(Ldap.INST.globalStartSuccess());
            }

            public void failure(Throwable throwable) {
                Notification.get().reportError(Ldap.INST.globalStartFail());
            }
        });
    }

    private void enableLdapProperties(Boolean bl) {
        if (Ajax.TOKEN.isDomainGlobal()) {
            for (HasEnabled hasEnabled : this.ldapPropertiesTextBox) {
                hasEnabled.setEnabled(bl.booleanValue());
            }
            this.ldapProtocol.setEnabled(bl.booleanValue());
            this.ldapImportEnabled.setEnabled(true);
        } else {
            this.ldapImportEnabled.setEnabled(false);
        }
        this.ldapConnTest.setEnabled(bl.booleanValue());
        if (!this.propertiesChanged) {
            for (Button button : this.ldapJobActionsButtons) {
                button.setEnabled(bl.booleanValue());
            }
        }
    }

    private void displayLastSyncStatus() {
        JobExecutionQuery jobExecutionQuery = new JobExecutionQuery();
        jobExecutionQuery.domain = this.domainName;
        jobExecutionQuery.jobId = "net.bluemind.system.ldap.importation.ImportLDAPjob";
        jobExecutionQuery.from = 0;
        jobExecutionQuery.size = 1;
        new JobGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).searchExecution(jobExecutionQuery, (AsyncHandler)new AsyncHandler<ListResult<JobExecution>>(){

            public void success(ListResult<JobExecution> listResult) {
                if (listResult.total == 0L) {
                    EditDomainLdapEditor.this.setUnknownStatus(EditDomainLdapEditor.this.lastSyncStatus);
                    return;
                }
                EditDomainLdapEditor.this.fillElement(EditDomainLdapEditor.this.lastSyncStatus, (JobExecution)listResult.values.get(0));
            }

            public void failure(Throwable throwable) {
                EditDomainLdapEditor.this.setUnknownStatus(EditDomainLdapEditor.this.lastSyncStatus);
            }
        });
        jobExecutionQuery.statuses.clear();
        jobExecutionQuery.statuses.add(JobExitStatus.SUCCESS);
        new JobGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).searchExecution(jobExecutionQuery, (AsyncHandler)new AsyncHandler<ListResult<JobExecution>>(){

            public void success(ListResult<JobExecution> listResult) {
                if (listResult.total == 0L) {
                    EditDomainLdapEditor.this.setUnknownStatus(EditDomainLdapEditor.this.lastSyncSuccessful);
                    return;
                }
                EditDomainLdapEditor.this.fillElement(EditDomainLdapEditor.this.lastSyncSuccessful, (JobExecution)listResult.values.get(0));
            }

            public void failure(Throwable throwable) {
                EditDomainLdapEditor.this.setUnknownStatus(EditDomainLdapEditor.this.lastSyncSuccessful);
            }
        });
    }

    private void fillElement(JobStatusPanel jobStatusPanel, JobExecution jobExecution) {
        jobStatusPanel.add((Widget)this.getIcon(jobExecution.status));
        jobStatusPanel.add((Widget)new InlineHTML(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM).format(jobExecution.startDate)));
        jobStatusPanel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                HashMap hashMap = EditDomainLdapEditor.this.getJobExecutionLink();
                Actions.get().showWithParams2("editJob", (Map)hashMap);
            }
        });
    }

    private void setUnknownStatus(JobStatusPanel jobStatusPanel) {
        Label label = new Label();
        label.setStyleName("fa fa-circle-thin fa-lg");
        jobStatusPanel.add((Widget)label);
        jobStatusPanel.add((Widget)new InlineHTML(Ldap.INST.unknownLastSync()));
        jobStatusPanel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                HashMap hashMap = EditDomainLdapEditor.this.getJobExecutionLink();
                Actions.get().showWithParams2("editJob", (Map)hashMap);
            }
        });
    }

    private Label getIcon(JobExitStatus jobExitStatus) {
        Label label = new Label();
        String string = "fa fa-circle-thin fa-lg";
        switch (jobExitStatus) {
            case SUCCESS: {
                string = "fa fa-check fa-lg";
                break;
            }
            case FAILURE: {
                string = "fa fa-close fa-lg";
                break;
            }
            case COMPLETED_WITH_WARNINGS: {
                string = "fa fa-warning fa-lg";
            }
        }
        label.setStyleName(string);
        return label;
    }

    private HashMap<String, String> getJobExecutionLink() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobId", "net.bluemind.system.ldap.importation.ImportLDAPjob");
        hashMap.put("domain", this.domainName);
        hashMap.put("activeTab", "2");
        return hashMap;
    }

    private void propertiesChanged() {
        this.propertiesChanged = true;
        for (Button button : this.disableOnChange) {
            button.setEnabled(false);
            button.setTitle(Ldap.INST.buttonTipDisbledOnChange());
        }
    }

    static interface EditDomainLdapUiBinder
    extends UiBinder<HTMLPanel, EditDomainLdapEditor> {
    }
}

