/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class AggregationProfileShardResult
implements Writeable,
ToXContentFragment {
    public static final String AGGREGATIONS = "aggregations";
    private final List<ProfileResult> aggProfileResults;

    public AggregationProfileShardResult(List<ProfileResult> aggProfileResults) {
        this.aggProfileResults = aggProfileResults;
    }

    public AggregationProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.aggProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.aggProfileResults.add(new ProfileResult(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aggProfileResults.size());
        for (ProfileResult p : this.aggProfileResults) {
            p.writeTo(out);
        }
    }

    public List<ProfileResult> getProfileResults() {
        return Collections.unmodifiableList(this.aggProfileResults);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(AGGREGATIONS);
        for (ProfileResult p : this.aggProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationProfileShardResult other = (AggregationProfileShardResult)obj;
        return this.aggProfileResults.equals(other.aggProfileResults);
    }

    public int hashCode() {
        return this.aggProfileResults.hashCode();
    }

    public String toString() {
        return Objects.toString(this);
    }

    public static AggregationProfileShardResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser);
        ArrayList<ProfileResult> aggProfileResults = new ArrayList<ProfileResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            aggProfileResults.add(ProfileResult.fromXContent(parser));
        }
        return new AggregationProfileShardResult(aggProfileResults);
    }
}

