/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchDocValuesContext;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

final class DefaultSearchContext
extends SearchContext {
    private final ReaderContext readerContext;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final LongSupplier relativeTimeSupplier;
    private SearchType searchType;
    private final IndexShard indexShard;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private final float queryBoost;
    private final boolean lowLevelCancellation;
    private TimeValue timeout;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private boolean explain;
    private boolean version = false;
    private boolean seqAndPrimaryTerm = false;
    private StoredFieldsContext storedFields;
    private ScriptFieldsContext scriptFields;
    private FetchSourceContext fetchSourceContext;
    private FetchDocValuesContext docValuesContext;
    private FetchFieldsContext fetchFieldsContext;
    private int from = -1;
    private int size = -1;
    private SortAndFormats sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private int trackTotalHitsUpTo = 10000;
    private FieldDoc searchAfter;
    private CollapseContext collapse;
    private SliceBuilder sliceBuilder;
    private SearchShardTask task;
    private final Version minNodeVersion;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedQuery postFilter;
    private Query aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadSize;
    private SearchContextAggregations aggregations;
    private SearchHighlightContext highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreContext> rescore;
    private Profilers profilers;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();
    private final Map<Class<?>, Collector> queryCollectors = new HashMap();
    private final SearchExecutionContext searchExecutionContext;
    private final FetchPhase fetchPhase;

    DefaultSearchContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTarget shardTarget, LongSupplier relativeTimeSupplier, TimeValue timeout, FetchPhase fetchPhase, boolean lowLevelCancellation, Version minNodeVersion) throws IOException {
        this.readerContext = readerContext;
        this.request = request;
        this.fetchPhase = fetchPhase;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.dfsResult = new DfsSearchResult(readerContext.id(), shardTarget, request);
        this.queryResult = new QuerySearchResult(readerContext.id(), shardTarget, request);
        this.fetchResult = new FetchSearchResult(readerContext.id(), shardTarget);
        this.indexService = readerContext.indexService();
        this.indexShard = readerContext.indexShard();
        Engine.Searcher engineSearcher = readerContext.acquireSearcher("search");
        this.searcher = new ContextIndexSearcher(engineSearcher.getIndexReader(), engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), lowLevelCancellation);
        this.releasables.addAll(org.elasticsearch.core.List.of(engineSearcher, this.searcher));
        this.relativeTimeSupplier = relativeTimeSupplier;
        this.timeout = timeout;
        this.minNodeVersion = minNodeVersion;
        this.searchExecutionContext = this.indexService.newSearchExecutionContext(request.shardId().id(), request.shardRequestIndex(), this.searcher, request::nowInMillis, shardTarget.getClusterAlias(), request.getRuntimeMappings());
        this.searchExecutionContext.setTypes(request.types());
        this.queryBoost = request.indexBoost();
        this.lowLevelCancellation = lowLevelCancellation;
    }

    @Override
    public void preProcess() {
        int maxResultWindow;
        long size;
        if (this.hasOnlySuggest()) {
            return;
        }
        long from = this.from() == -1 ? 0L : (long)this.from();
        long resultWindow = from + (size = this.size() == -1 ? 10L : (long)this.size());
        if (resultWindow > (long)(maxResultWindow = this.indexService.getIndexSettings().getMaxResultWindow())) {
            if (this.scrollContext() == null) {
                throw new IllegalArgumentException("Result window is too large, from + size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. See the scroll api for a more efficient way to request large data sets. This limit can be set by changing the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
            }
            throw new IllegalArgumentException("Batch size is too large, size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. Scroll batch sizes cost as much memory as result windows so they are controlled by the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        if (this.rescore != null) {
            if (this.sort != null) {
                throw new IllegalArgumentException("Cannot use [sort] option in conjunction with [rescore].");
            }
            int maxWindow = this.indexService.getIndexSettings().getMaxRescoreWindow();
            for (RescoreContext rescoreContext : this.rescore()) {
                if (rescoreContext.getWindowSize() <= maxWindow) continue;
                throw new IllegalArgumentException("Rescore window [" + rescoreContext.getWindowSize() + "] is too large. It must be less than [" + maxWindow + "]. This prevents allocating massive heaps for storing the results to be rescored. This limit can be set by changing the [" + IndexSettings.MAX_RESCORE_WINDOW_SETTING.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null && this.scrollContext() != null) {
            int sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerScroll();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new IllegalArgumentException("The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_SCROLL.getKey() + "] index level setting.");
            }
        }
        try {
            QueryBuilder queryBuilder = this.request.getAliasFilter().getQueryBuilder();
            this.aliasFilter = queryBuilder == null ? null : queryBuilder.toQuery(this.searchExecutionContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.query == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new BoostQuery(this.query, this.queryBoost), this.parsedQuery()));
        }
        this.query = this.buildFilteredQuery(this.query);
        if (this.lowLevelCancellation) {
            this.searcher().addQueryCancellation(() -> {
                SearchShardTask task = this.getTask();
                if (task != null) {
                    task.ensureNotCancelled();
                }
            });
        }
    }

    @Override
    public Query buildFilteredQuery(Query query) {
        ArrayList<Query> filters = new ArrayList<Query>();
        Query typeFilter = this.createTypeFilter(this.searchExecutionContext.getTypes());
        if (typeFilter != null) {
            filters.add(typeFilter);
        }
        NestedHelper nestedHelper = new NestedHelper(this.searchExecutionContext::getObjectMapper, this.searchExecutionContext::isFieldMapped);
        if (this.searchExecutionContext.hasNested() && nestedHelper.mightMatchNestedDocs(query) && (this.aliasFilter == null || nestedHelper.mightMatchNestedDocs(this.aliasFilter))) {
            filters.add(Queries.newNonNestedFilter(this.searchExecutionContext.indexVersionCreated()));
        }
        if (this.aliasFilter != null) {
            filters.add(this.aliasFilter);
        }
        if (this.sliceBuilder != null) {
            Query slicedQuery = this.sliceBuilder.toFilter(this.request, this.searchExecutionContext);
            if (slicedQuery instanceof MatchNoDocsQuery) {
                return slicedQuery;
            }
            filters.add(slicedQuery);
        }
        if (filters.isEmpty()) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(query, BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    private Query createTypeFilter(String[] types) {
        if (types != null && types.length >= 1) {
            SearchExecutionContext queryShardContext = this.getSearchExecutionContext();
            if (queryShardContext.getType() == null) {
                return null;
            }
            TypeFieldMapper.TypeFieldType ft = new TypeFieldMapper.TypeFieldType(queryShardContext.getType());
            return ft.typeFilter(types);
        }
        return null;
    }

    @Override
    public ShardSearchContextId id() {
        return this.readerContext.id();
    }

    @Override
    public String source() {
        return "search";
    }

    @Override
    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    @Override
    public ScrollContext scrollContext() {
        return this.readerContext.scrollContext();
    }

    @Override
    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    @Override
    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    @Override
    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    @Override
    public SearchHighlightContext highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchHighlightContext highlight) {
        this.highlight = highlight;
    }

    @Override
    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    @Override
    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    @Override
    public List<RescoreContext> rescore() {
        if (this.rescore == null) {
            return Collections.emptyList();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public boolean hasFetchSourceContext() {
        return this.fetchSourceContext != null;
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public FetchDocValuesContext docValuesContext() {
        return this.docValuesContext;
    }

    @Override
    public SearchContext docValuesContext(FetchDocValuesContext docValuesContext) {
        this.docValuesContext = docValuesContext;
        return this;
    }

    @Override
    public FetchFieldsContext fetchFieldsContext() {
        return this.fetchFieldsContext;
    }

    @Override
    public SearchContext fetchFieldsContext(FetchFieldsContext fetchFieldsContext) {
        this.fetchFieldsContext = fetchFieldsContext;
        return this;
    }

    @Override
    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    @Override
    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public BitsetFilterCache bitsetFilterCache() {
        return this.indexService.cache().bitsetFilterCache();
    }

    @Override
    public TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public void timeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    @Override
    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    @Override
    public Float minimumScore() {
        return this.minimumScore;
    }

    @Override
    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public SortAndFormats sort() {
        return this.sort;
    }

    @Override
    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Override
    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public SearchContext trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    @Override
    public int trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Override
    public SearchContext searchAfter(FieldDoc searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    @Override
    public boolean lowLevelCancellation() {
        return this.lowLevelCancellation;
    }

    @Override
    public FieldDoc searchAfter() {
        return this.searchAfter;
    }

    @Override
    public SearchContext collapse(CollapseContext collapse) {
        this.collapse = collapse;
        return this;
    }

    @Override
    public CollapseContext collapse() {
        return this.collapse;
    }

    public SearchContext sliceBuilder(SliceBuilder sliceBuilder) {
        this.sliceBuilder = sliceBuilder;
        return this;
    }

    @Override
    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    @Override
    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasStoredFields() {
        return this.storedFields != null && this.storedFields.fieldNames() != null;
    }

    @Override
    public StoredFieldsContext storedFieldsContext() {
        return this.storedFields;
    }

    @Override
    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        this.storedFields = storedFieldsContext;
        return this;
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Override
    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    @Override
    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version) {
        this.version = version;
    }

    @Override
    public boolean seqNoAndPrimaryTerm() {
        return this.seqAndPrimaryTerm;
    }

    @Override
    public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
        this.seqAndPrimaryTerm = seqNoAndPrimaryTerm;
    }

    @Override
    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    @Override
    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    @Override
    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchPhase fetchPhase() {
        return this.fetchPhase;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public long getRelativeTimeInMillis() {
        return this.relativeTimeSupplier.getAsLong();
    }

    @Override
    public Map<Class<?>, Collector> queryCollectors() {
        return this.queryCollectors;
    }

    @Override
    public SearchExecutionContext getSearchExecutionContext() {
        return this.searchExecutionContext;
    }

    @Override
    public Profilers getProfilers() {
        return this.profilers;
    }

    public void setProfilers(Profilers profilers) {
        this.profilers = profilers;
    }

    @Override
    public void setTask(SearchShardTask task) {
        this.task = task;
    }

    @Override
    public SearchShardTask getTask() {
        return this.task;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public ReaderContext readerContext() {
        return this.readerContext;
    }
}

