/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.xcontent.XContentParser;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction>
implements RestRequestFilter {
    private static final Set<String> FILTERED_FIELDS = Collections.singleton("source.remote.host.password");

    public RestReindexAction() {
        super(ReindexAction.INSTANCE);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_reindex"));
    }

    @Override
    public String getName() {
        return "reindex_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request, NamedWriteableRegistry namedWriteableRegistry) throws IOException {
        ReindexRequest internal;
        if (request.hasParam("pipeline")) {
            throw new IllegalArgumentException("_reindex doesn't support [pipeline] as a query parameter. Specify it in the [dest] object instead.");
        }
        try (XContentParser parser = request.contentParser();){
            internal = ReindexRequest.fromXContent(parser);
        }
        if (request.hasParam("scroll")) {
            internal.setScroll(TimeValue.parseTimeValue(request.param("scroll"), "scroll"));
        }
        if (request.hasParam("require_alias")) {
            internal.setRequireAlias(request.paramAsBoolean("require_alias", false));
        }
        return internal;
    }

    @Override
    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

