/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractBulkByQueryRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends ActionType<BulkByScrollResponse>>
extends AbstractBaseReindexRestHandler<Request, A> {
    protected AbstractBulkByQueryRestHandler(A action) {
        super(action);
    }

    protected void parseInternalRequest(Request internal, RestRequest restRequest, NamedWriteableRegistry namedWriteableRegistry, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        assert (internal != null) : "Request should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        SearchRequest searchRequest = ((AbstractBulkByScrollRequest)internal).getSearchRequest();
        try (XContentParser parser = this.extractRequestSpecificFields(restRequest, bodyConsumers);){
            RestSearchAction.parseSearchRequest(searchRequest, restRequest, parser, namedWriteableRegistry, size -> this.setMaxDocsFromSearchSize(internal, size));
        }
        searchRequest.source().size(restRequest.paramAsInt("scroll_size", searchRequest.source().size()));
        String conflicts = restRequest.param("conflicts");
        if (conflicts != null) {
            ((AbstractBulkByScrollRequest)internal).setConflicts(conflicts);
        }
        if (restRequest.hasParam("search_timeout")) {
            searchRequest.source().timeout(restRequest.paramAsTime("search_timeout", null));
        }
    }

    private XContentParser extractRequestSpecificFields(RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        if (!restRequest.hasContentOrSourceParam()) {
            return null;
        }
        try (XContentParser parser = restRequest.contentOrSourceParamParser();){
            XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());
            try {
                Map<String, Object> body = parser.map();
                for (Map.Entry<String, Consumer<Object>> consumer : bodyConsumers.entrySet()) {
                    Object value = body.remove(consumer.getKey());
                    if (value == null) continue;
                    consumer.getValue().accept(value);
                }
                XContentParser xContentParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), BytesReference.bytes(builder.map(body)).streamInput());
                if (builder != null) {
                    builder.close();
                }
                return xContentParser;
            }
            catch (Throwable throwable) {
                if (builder != null) {
                    try {
                        builder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private void setMaxDocsFromSearchSize(Request request, int size) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, null, "size", "max_docs");
        AbstractBulkByQueryRestHandler.setMaxDocsValidateIdentical(request, size);
    }
}

