/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightPhase;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;

final class PercolatorHighlightSubFetchPhase
implements FetchSubPhase {
    private final HighlightPhase highlightPhase;

    PercolatorHighlightSubFetchPhase(Map<String, Highlighter> highlighters) {
        this.highlightPhase = new HighlightPhase(highlighters);
    }

    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext fetchContext) {
        if (fetchContext.highlight() == null) {
            return null;
        }
        final List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(fetchContext.query());
        if (percolateQueries.isEmpty()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){
            LeafReaderContext ctx;

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
                this.ctx = readerContext;
            }

            @Override
            public void process(FetchSubPhase.HitContext hit) throws IOException {
                boolean singlePercolateQuery = percolateQueries.size() == 1;
                for (PercolateQuery percolateQuery : percolateQueries) {
                    DocumentField field;
                    String fieldName = singlePercolateQuery ? "_percolator_document_slot" : "_percolator_document_slot_" + percolateQuery.getName();
                    IndexSearcher percolatorIndexSearcher = percolateQuery.getPercolatorIndexSearcher();
                    PercolateQuery.QueryStore queryStore = percolateQuery.getQueryStore();
                    LeafReaderContext percolatorLeafReaderContext = percolatorIndexSearcher.getIndexReader().leaves().get(0);
                    Query query = queryStore.getQueries(this.ctx).apply(hit.docId());
                    if (query == null || (field = hit.hit().field(fieldName)) == null) continue;
                    for (Object matchedSlot : field.getValues()) {
                        int slot = (Integer)matchedSlot;
                        BytesReference document = percolateQuery.getDocuments().get(slot);
                        FetchSubPhase.HitContext subContext = new FetchSubPhase.HitContext(new SearchHit(slot, "unknown", new Text(hit.hit().getType()), Collections.emptyMap(), Collections.emptyMap()), percolatorLeafReaderContext, slot);
                        subContext.sourceLookup().setSource(document);
                        SearchHighlightContext highlight = new SearchHighlightContext(fetchContext.highlight().fields(), true);
                        FetchSubPhaseProcessor processor = PercolatorHighlightSubFetchPhase.this.highlightPhase.getProcessor(fetchContext, highlight, query);
                        processor.process(subContext);
                        for (Map.Entry<String, HighlightField> entry : subContext.hit().getHighlightFields().entrySet()) {
                            String hlFieldName;
                            if (percolateQuery.getDocuments().size() == 1) {
                                hlFieldName = singlePercolateQuery ? entry.getKey() : percolateQuery.getName() + "_" + entry.getKey();
                                hit.hit().getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, entry.getValue().fragments()));
                                continue;
                            }
                            hlFieldName = singlePercolateQuery ? slot + "_" + entry.getKey() : percolateQuery.getName() + "_" + slot + "_" + entry.getKey();
                            hit.hit().getHighlightFields().put(hlFieldName, new HighlightField(hlFieldName, entry.getValue().fragments()));
                        }
                    }
                }
            }
        };
    }

    static List<PercolateQuery> locatePercolatorQuery(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        final ArrayList<PercolateQuery> queries = new ArrayList<PercolateQuery>();
        query.visit(new QueryVisitor(){

            @Override
            public void visitLeaf(Query query) {
                if (query instanceof PercolateQuery) {
                    queries.add((PercolateQuery)query);
                }
            }
        });
        return queries;
    }
}

