/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.BinaryRange;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CoveringQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.QueryAnalyzer;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class PercolatorFieldMapper
extends FieldMapper {
    static final XContentType QUERY_BUILDER_CONTENT_TYPE = XContentType.SMILE;
    static final Setting<Boolean> INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING = Setting.boolSetting("index.percolator.map_unmapped_fields_as_text", false, Setting.Property.IndexScope);
    static final String CONTENT_TYPE = "percolator";
    static final byte FIELD_VALUE_SEPARATOR = 0;
    static final String EXTRACTION_COMPLETE = "complete";
    static final String EXTRACTION_PARTIAL = "partial";
    static final String EXTRACTION_FAILED = "failed";
    static final String EXTRACTED_TERMS_FIELD_NAME = "extracted_terms";
    static final String EXTRACTION_RESULT_FIELD_NAME = "extraction_result";
    static final String QUERY_BUILDER_FIELD_NAME = "query_builder_field";
    static final String RANGE_FIELD_NAME = "range_field";
    static final String MINIMUM_SHOULD_MATCH_FIELD_NAME = "minimum_should_match_field";
    private final Supplier<SearchExecutionContext> searchExecutionContext;
    private final KeywordFieldMapper queryTermsField;
    private final KeywordFieldMapper extractionResultField;
    private final BinaryFieldMapper queryBuilderField;
    private final NumberFieldMapper minimumShouldMatchFieldMapper;
    private final RangeFieldMapper rangeFieldMapper;
    private final boolean mapUnmappedFieldsAsText;
    private static final FieldType INDEXED_KEYWORD = new FieldType();

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.searchExecutionContext, this.mapUnmappedFieldsAsText).init(this);
    }

    private static boolean getMapUnmappedFieldAsText(Settings indexSettings) {
        return INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.get(indexSettings);
    }

    PercolatorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Supplier<SearchExecutionContext> searchExecutionContext, KeywordFieldMapper queryTermsField, KeywordFieldMapper extractionResultField, BinaryFieldMapper queryBuilderField, RangeFieldMapper rangeFieldMapper, NumberFieldMapper minimumShouldMatchFieldMapper, boolean mapUnmappedFieldsAsText) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.searchExecutionContext = searchExecutionContext;
        this.queryTermsField = queryTermsField;
        this.extractionResultField = extractionResultField;
        this.queryBuilderField = queryBuilderField;
        this.minimumShouldMatchFieldMapper = minimumShouldMatchFieldMapper;
        this.rangeFieldMapper = rangeFieldMapper;
        this.mapUnmappedFieldsAsText = mapUnmappedFieldsAsText;
    }

    @Override
    public void parse(DocumentParserContext context) throws IOException {
        SearchExecutionContext executionContext = this.searchExecutionContext.get();
        if (context.doc().getField(this.queryBuilderField.name()) != null) {
            throw new IllegalArgumentException("a document can only contain one percolator query");
        }
        PercolatorFieldMapper.configureContext(executionContext, this.isMapUnmappedFieldAsText());
        XContentParser parser = context.parser();
        QueryBuilder queryBuilder = PercolatorFieldMapper.parseQueryBuilder(parser, parser.getTokenLocation());
        PercolatorFieldMapper.verifyQuery(queryBuilder);
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch(queryBuilder, executionContext, future);
        queryBuilder = (QueryBuilder)future.actionGet();
        Version indexVersion = context.indexSettings().getIndexVersionCreated();
        PercolatorFieldMapper.createQueryBuilderField(indexVersion, this.queryBuilderField, queryBuilder, context);
        QueryBuilder queryBuilderForProcessing = queryBuilder.rewrite(new SearchExecutionContext(executionContext));
        Query query = queryBuilderForProcessing.toQuery(executionContext);
        this.processQuery(query, context);
    }

    static void createQueryBuilderField(Version indexVersion, BinaryFieldMapper qbField, QueryBuilder queryBuilder, DocumentParserContext context) throws IOException {
        block17: {
            if (indexVersion.onOrAfter(Version.V_6_0_0_beta2)) {
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
                     OutputStreamStreamOutput out = new OutputStreamStreamOutput(stream);){
                    out.setVersion(indexVersion);
                    out.writeNamedWriteable(queryBuilder);
                    qbField.indexValue(context, stream.toByteArray());
                    break block17;
                }
            }
            try (XContentBuilder builder = XContentFactory.contentBuilder(QUERY_BUILDER_CONTENT_TYPE);){
                queryBuilder.toXContent(builder, new ToXContent.MapParams(Collections.emptyMap()));
                builder.flush();
                byte[] queryBuilderAsBytes = BytesReference.toBytes(BytesReference.bytes(builder));
                context.doc().add(new BinaryDocValuesField(qbField.name(), new BytesRef(queryBuilderAsBytes)));
            }
        }
    }

    void processQuery(Query query, DocumentParserContext context) {
        LuceneDocument doc = context.doc();
        PercolatorFieldType pft = (PercolatorFieldType)this.fieldType();
        Version indexVersion = context.indexSettings().getIndexVersionCreated();
        QueryAnalyzer.Result result = QueryAnalyzer.analyze(query, indexVersion);
        if (result == QueryAnalyzer.Result.UNKNOWN) {
            doc.add(new Field(pft.extractionResultField.name(), EXTRACTION_FAILED, (IndexableFieldType)INDEXED_KEYWORD));
            return;
        }
        for (QueryAnalyzer.QueryExtraction extraction : result.extractions) {
            if (extraction.term != null) {
                BytesRefBuilder builder = new BytesRefBuilder();
                builder.append(new BytesRef(extraction.field()));
                builder.append((byte)0);
                builder.append(extraction.bytes());
                doc.add(new Field(this.queryTermsField.name(), builder.toBytesRef(), (IndexableFieldType)INDEXED_KEYWORD));
                continue;
            }
            if (extraction.range == null) continue;
            byte[] min = extraction.range.lowerPoint;
            byte[] max = extraction.range.upperPoint;
            doc.add(new BinaryRange(this.rangeFieldMapper.name(), PercolatorFieldMapper.encodeRange(extraction.range.fieldName, min, max)));
        }
        Version indexVersionCreated = context.indexSettings().getIndexVersionCreated();
        if (result.matchAllDocs) {
            doc.add(new Field(this.extractionResultField.name(), EXTRACTION_FAILED, (IndexableFieldType)INDEXED_KEYWORD));
            if (result.verified) {
                doc.add(new Field(this.extractionResultField.name(), EXTRACTION_COMPLETE, (IndexableFieldType)INDEXED_KEYWORD));
            }
        } else if (result.verified) {
            doc.add(new Field(this.extractionResultField.name(), EXTRACTION_COMPLETE, (IndexableFieldType)INDEXED_KEYWORD));
        } else {
            doc.add(new Field(this.extractionResultField.name(), EXTRACTION_PARTIAL, (IndexableFieldType)INDEXED_KEYWORD));
        }
        context.addToFieldNames(this.fieldType().name());
        if (indexVersionCreated.onOrAfter(Version.V_6_1_0)) {
            doc.add(new NumericDocValuesField(this.minimumShouldMatchFieldMapper.name(), result.minimumShouldMatch));
        }
    }

    static void configureContext(SearchExecutionContext context, boolean mapUnmappedFieldsAsString) {
        context.setAllowUnmappedFields(false);
        context.setMapUnmappedFieldAsString(mapUnmappedFieldsAsString);
    }

    static QueryBuilder parseQueryBuilder(XContentParser parser, XContentLocation location) {
        try {
            return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        }
        catch (IOException e) {
            throw new ParsingException(location, "Failed to parse", e, new Object[0]);
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        return Arrays.asList(this.queryTermsField, this.extractionResultField, this.queryBuilderField, this.minimumShouldMatchFieldMapper, this.rangeFieldMapper).iterator();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("should not be invoked");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    boolean isMapUnmappedFieldAsText() {
        return this.mapUnmappedFieldsAsText;
    }

    static void verifyQuery(QueryBuilder queryBuilder) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (queryBuilder.getName().equals("has_child")) {
                                throw new IllegalArgumentException("the [has_child] query is unsupported inside a percolator query");
                            }
                            if (queryBuilder.getName().equals("has_parent")) {
                                throw new IllegalArgumentException("the [has_parent] query is unsupported inside a percolator query");
                            }
                            if (!(queryBuilder instanceof BoolQueryBuilder)) break block4;
                            BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                            ArrayList<QueryBuilder> clauses = new ArrayList<QueryBuilder>();
                            clauses.addAll(boolQueryBuilder.filter());
                            clauses.addAll(boolQueryBuilder.must());
                            clauses.addAll(boolQueryBuilder.mustNot());
                            clauses.addAll(boolQueryBuilder.should());
                            for (QueryBuilder clause : clauses) {
                                PercolatorFieldMapper.verifyQuery(clause);
                            }
                            break block5;
                        }
                        if (!(queryBuilder instanceof ConstantScoreQueryBuilder)) break block6;
                        PercolatorFieldMapper.verifyQuery(((ConstantScoreQueryBuilder)queryBuilder).innerQuery());
                        break block5;
                    }
                    if (!(queryBuilder instanceof FunctionScoreQueryBuilder)) break block7;
                    PercolatorFieldMapper.verifyQuery(((FunctionScoreQueryBuilder)queryBuilder).query());
                    break block5;
                }
                if (!(queryBuilder instanceof BoostingQueryBuilder)) break block8;
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).negativeQuery());
                PercolatorFieldMapper.verifyQuery(((BoostingQueryBuilder)queryBuilder).positiveQuery());
                break block5;
            }
            if (!(queryBuilder instanceof DisMaxQueryBuilder)) break block5;
            DisMaxQueryBuilder disMaxQueryBuilder = (DisMaxQueryBuilder)queryBuilder;
            for (QueryBuilder innerQueryBuilder : disMaxQueryBuilder.innerQueries()) {
                PercolatorFieldMapper.verifyQuery(innerQueryBuilder);
            }
        }
    }

    static byte[] encodeRange(String rangeFieldName, byte[] minEncoded, byte[] maxEncoded) {
        assert (minEncoded.length == maxEncoded.length);
        byte[] bytes = new byte[32];
        BytesRef fieldAsBytesRef = new BytesRef(rangeFieldName);
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128(fieldAsBytesRef.bytes, fieldAsBytesRef.offset, fieldAsBytesRef.length, 0L, hash);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putLong(hash.h1).putLong(hash.h2).putLong(hash.h1).putLong(hash.h2);
        assert (bb.position() == bb.limit());
        int offset = 16 - minEncoded.length;
        System.arraycopy(minEncoded, 0, bytes, offset, minEncoded.length);
        System.arraycopy(maxEncoded, 0, bytes, 16 + offset, maxEncoded.length);
        return bytes;
    }

    static {
        INDEXED_KEYWORD.setTokenized(false);
        INDEXED_KEYWORD.setOmitNorms(true);
        INDEXED_KEYWORD.setIndexOptions(IndexOptions.DOCS);
        INDEXED_KEYWORD.freeze();
    }

    static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Supplier<SearchExecutionContext> searchExecutionContext;
        private final boolean mapUnmappedFieldsAsText;

        Builder(String fieldName, Supplier<SearchExecutionContext> searchExecutionContext, boolean mapUnmappedFieldsAsText) {
            super(fieldName);
            this.searchExecutionContext = searchExecutionContext;
            this.mapUnmappedFieldsAsText = mapUnmappedFieldsAsText;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta);
        }

        @Override
        public PercolatorFieldMapper build(MapperBuilderContext context) {
            PercolatorFieldType fieldType = new PercolatorFieldType(context.buildFullName(this.name), this.meta.getValue());
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build(this, context);
            context = context.createChildContext(this.name);
            KeywordFieldMapper extractedTermsField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTED_TERMS_FIELD_NAME, context);
            fieldType.queryTermsField = extractedTermsField.fieldType();
            KeywordFieldMapper extractionResultField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTION_RESULT_FIELD_NAME, context);
            fieldType.extractionResultField = extractionResultField.fieldType();
            BinaryFieldMapper queryBuilderField = Builder.createQueryBuilderFieldBuilder(context);
            fieldType.queryBuilderField = queryBuilderField.fieldType();
            RangeFieldMapper rangeFieldMapper = Builder.createExtractedRangeFieldBuilder(PercolatorFieldMapper.RANGE_FIELD_NAME, RangeType.IP, context);
            fieldType.rangeField = rangeFieldMapper.fieldType();
            NumberFieldMapper minimumShouldMatchFieldMapper = Builder.createMinimumShouldMatchField(context);
            fieldType.minimumShouldMatchField = minimumShouldMatchFieldMapper.fieldType();
            fieldType.mapUnmappedFieldsAsText = this.mapUnmappedFieldsAsText;
            return new PercolatorFieldMapper(this.name(), fieldType, multiFields, this.copyTo.build(), this.searchExecutionContext, extractedTermsField, extractionResultField, queryBuilderField, rangeFieldMapper, minimumShouldMatchFieldMapper, this.mapUnmappedFieldsAsText);
        }

        static KeywordFieldMapper createExtractQueryFieldBuilder(String name, MapperBuilderContext context) {
            KeywordFieldMapper.Builder queryMetadataFieldBuilder = new KeywordFieldMapper.Builder(name);
            queryMetadataFieldBuilder.docValues(false);
            return queryMetadataFieldBuilder.build(context);
        }

        static BinaryFieldMapper createQueryBuilderFieldBuilder(MapperBuilderContext context) {
            BinaryFieldMapper.Builder builder = new BinaryFieldMapper.Builder(PercolatorFieldMapper.QUERY_BUILDER_FIELD_NAME, true);
            return builder.build(context);
        }

        static RangeFieldMapper createExtractedRangeFieldBuilder(String name, RangeType rangeType, MapperBuilderContext context) {
            RangeFieldMapper.Builder builder = new RangeFieldMapper.Builder(name, rangeType, true, Version.CURRENT);
            builder.docValues(false);
            return builder.build(context);
        }

        static NumberFieldMapper createMinimumShouldMatchField(MapperBuilderContext context) {
            NumberFieldMapper.Builder builder = NumberFieldMapper.Builder.docValuesOnly(PercolatorFieldMapper.MINIMUM_SHOULD_MATCH_FIELD_NAME, NumberFieldMapper.NumberType.INTEGER);
            return builder.build(context);
        }
    }

    static class PercolatorFieldType
    extends MappedFieldType {
        MappedFieldType queryTermsField;
        MappedFieldType extractionResultField;
        MappedFieldType queryBuilderField;
        MappedFieldType minimumShouldMatchField;
        RangeFieldMapper.RangeFieldType rangeField;
        boolean mapUnmappedFieldsAsText;

        private PercolatorFieldType(String name, Map<String, String> meta) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
        }

        @Override
        public String typeName() {
            return PercolatorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException(context, "Percolator fields are not searchable directly, use a percolate query instead", new Object[0]);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        Query percolateQuery(String name, PercolateQuery.QueryStore queryStore, List<BytesReference> documents, IndexSearcher searcher, boolean excludeNestedDocuments, Version indexVersion) throws IOException {
            IndexReader indexReader = searcher.getIndexReader();
            Tuple<BooleanQuery, Boolean> t = this.createCandidateQuery(indexReader, indexVersion);
            Query candidateQuery = t.v1();
            boolean canUseMinimumShouldMatchField = t.v2();
            Query verifiedMatchesQuery = canUseMinimumShouldMatchField && indexReader.maxDoc() == 1 ? new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_COMPLETE)) : new MatchNoDocsQuery("multiple or nested docs or CoveringQuery could not be used");
            Query filter = null;
            if (excludeNestedDocuments) {
                filter = Queries.newNonNestedFilter(indexVersion);
            }
            return new PercolateQuery(name, queryStore, documents, candidateQuery, searcher, filter, verifiedMatchesQuery);
        }

        Tuple<BooleanQuery, Boolean> createCandidateQuery(IndexReader indexReader, Version indexVersion) throws IOException {
            Tuple<List<BytesRef>, Map<String, List<byte[]>>> t = this.extractTermsAndRanges(indexReader);
            List<BytesRef> extractedTerms = t.v1();
            Map<String, List<byte[]>> encodedPointValuesByField = t.v2();
            boolean canUseMinimumShouldMatchField = 1 + extractedTerms.size() + encodedPointValuesByField.size() <= BooleanQuery.getMaxClauseCount();
            ArrayList<Query> subQueries = new ArrayList<Query>();
            for (Map.Entry<String, List<byte[]>> entry : encodedPointValuesByField.entrySet()) {
                String rangeFieldName = entry.getKey();
                List<byte[]> encodedPointValues = entry.getValue();
                byte[] min = encodedPointValues.get(0);
                byte[] max = encodedPointValues.get(1);
                Query query = BinaryRange.newIntersectsQuery(this.rangeField.name(), PercolatorFieldMapper.encodeRange(rangeFieldName, min, max));
                subQueries.add(query);
            }
            BooleanQuery.Builder candidateQuery = new BooleanQuery.Builder();
            if (canUseMinimumShouldMatchField && indexVersion.onOrAfter(Version.V_6_1_0)) {
                LongValuesSource valuesSource = LongValuesSource.fromIntField(this.minimumShouldMatchField.name());
                for (BytesRef extractedTerm : extractedTerms) {
                    subQueries.add(new TermQuery(new Term(this.queryTermsField.name(), extractedTerm)));
                }
                candidateQuery.add(new CoveringQuery(subQueries, valuesSource), BooleanClause.Occur.SHOULD);
            } else {
                candidateQuery.add(new TermInSetQuery(this.queryTermsField.name(), extractedTerms), BooleanClause.Occur.SHOULD);
                for (Query subQuery : subQueries) {
                    candidateQuery.add(subQuery, BooleanClause.Occur.SHOULD);
                }
            }
            candidateQuery.add(new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_FAILED)), BooleanClause.Occur.SHOULD);
            return new Tuple<BooleanQuery, Boolean>(candidateQuery.build(), canUseMinimumShouldMatchField);
        }

        Tuple<List<BytesRef>, Map<String, List<byte[]>>> extractTermsAndRanges(IndexReader indexReader) throws IOException {
            ArrayList<BytesRef> extractedTerms = new ArrayList<BytesRef>();
            HashMap encodedPointValuesByField = new HashMap();
            LeafReader reader = indexReader.leaves().get(0).reader();
            for (FieldInfo info : reader.getFieldInfos()) {
                Terms terms = reader.terms(info.name);
                if (terms != null) {
                    BytesRef fieldBr = new BytesRef(info.name);
                    TermsEnum tenum = terms.iterator();
                    BytesRef term = tenum.next();
                    while (term != null) {
                        BytesRefBuilder builder = new BytesRefBuilder();
                        builder.append(fieldBr);
                        builder.append((byte)0);
                        builder.append(term);
                        extractedTerms.add(builder.toBytesRef());
                        term = tenum.next();
                    }
                }
                if (info.getPointIndexDimensionCount() != 1) continue;
                PointValues values = reader.getPointValues(info.name);
                ArrayList<byte[]> encodedPointValues = new ArrayList<byte[]>();
                encodedPointValues.add((byte[])values.getMinPackedValue().clone());
                encodedPointValues.add((byte[])values.getMaxPackedValue().clone());
                encodedPointValuesByField.put(info.name, encodedPointValues);
            }
            return new Tuple<List<BytesRef>, Map<String, List<byte[]>>>(extractedTerms, encodedPointValuesByField);
        }
    }

    static class TypeParser
    implements Mapper.TypeParser {
        TypeParser() {
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            return new Builder(name, parserContext.searchExecutionContext(), PercolatorFieldMapper.getMapUnmappedFieldAsText(parserContext.getSettings()));
        }
    }
}

