/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class TokenCountFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final NamedAnalyzer analyzer;
    private final boolean enablePositionIncrements;
    private final Integer nullValue;

    private static TokenCountFieldMapper toType(FieldMapper in) {
        return (TokenCountFieldMapper)in;
    }

    protected TokenCountFieldMapper(String simpleName, MappedFieldType defaultFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, defaultFieldType, multiFields, copyTo);
        this.analyzer = (NamedAnalyzer)builder.analyzer.getValue();
        this.enablePositionIncrements = (Boolean)builder.enablePositionIncrements.getValue();
        this.nullValue = (Integer)builder.nullValue.getValue();
        this.index = (Boolean)builder.index.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.store = (Boolean)builder.store.getValue();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null && this.nullValue == null) {
            return;
        }
        int tokenCount = value == null ? this.nullValue : TokenCountFieldMapper.countPositions(this.analyzer, this.name(), value, this.enablePositionIncrements);
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.fieldType().name(), tokenCount, this.index, this.hasDocValues, this.store));
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> TokenCountFieldMapper.access$600(TokenCountFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> TokenCountFieldMapper.access$500(TokenCountFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> TokenCountFieldMapper.access$400(TokenCountFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<NamedAnalyzer> analyzer = FieldMapper.Parameter.analyzerParam("analyzer", true, m -> TokenCountFieldMapper.access$300(TokenCountFieldMapper.toType(m)), () -> null);
        private final FieldMapper.Parameter<Integer> nullValue = new FieldMapper.Parameter<Integer>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValues.nodeIntegerValue(o)), m -> TokenCountFieldMapper.access$200(TokenCountFieldMapper.toType(m))).acceptsNull();
        private final FieldMapper.Parameter<Boolean> enablePositionIncrements = FieldMapper.Parameter.boolParam("enable_position_increments", false, m -> TokenCountFieldMapper.access$100(TokenCountFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.hasDocValues, this.store, this.analyzer, this.nullValue, this.enablePositionIncrements, this.meta);
        }

        @Override
        public TokenCountFieldMapper build(MapperBuilderContext context) {
            if (this.analyzer.getValue() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + this.name + "] but wasn't.");
            }
            TokenCountFieldType ft = new TokenCountFieldType(context.buildFullName(this.name), (boolean)this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), this.nullValue.getValue(), this.meta.getValue());
            return new TokenCountFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    static class TokenCountFieldType
    extends NumberFieldMapper.NumberFieldType {
        TokenCountFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Number nullValue, Map<String, String> meta) {
            super(name, NumberFieldMapper.NumberType.INTEGER, isSearchable, isStored, hasDocValues, false, nullValue, meta, null, false, null);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (!this.hasDocValues()) {
                return (lookup, ignoredValues) -> org.elasticsearch.core.List.of();
            }
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this));
        }
    }
}

