/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.internal;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Objects;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class HttpHeadersWithAuthenticationContext
extends DefaultHttpHeaders {
    public final SetOnce<ThreadContext.StoredContext> authenticationContextSetOnce;

    public HttpHeadersWithAuthenticationContext(HttpHeaders httpHeaders) {
        this(httpHeaders, new SetOnce<ThreadContext.StoredContext>());
    }

    private HttpHeadersWithAuthenticationContext(HttpHeaders httpHeaders, SetOnce<ThreadContext.StoredContext> authenticationContextSetOnce) {
        this.set(httpHeaders);
        this.authenticationContextSetOnce = authenticationContextSetOnce;
    }

    private HttpHeadersWithAuthenticationContext(HttpHeaders httpHeaders, ThreadContext.StoredContext authenticationContext) {
        this(httpHeaders);
        if (authenticationContext != null) {
            this.setAuthenticationContext(authenticationContext);
        }
    }

    public void setAuthenticationContext(ThreadContext.StoredContext authenticationContext) {
        this.authenticationContextSetOnce.set(Objects.requireNonNull(authenticationContext));
    }

    public HttpHeaders copy() {
        return new HttpHeadersWithAuthenticationContext(super.copy(), this.authenticationContextSetOnce.get());
    }
}

