/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.http.netty4.Netty4HttpRequest;

@ChannelHandler.Sharable
class Netty4HttpRequestCreator
extends MessageToMessageDecoder<FullHttpRequest> {
    Netty4HttpRequestCreator() {
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest msg, List<Object> out) {
        if (msg.decoderResult().isFailure()) {
            Exception nonError;
            Throwable cause = msg.decoderResult().cause();
            if (cause instanceof Error) {
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                nonError = new Exception(cause);
            } else {
                nonError = (Exception)cause;
            }
            out.add(new Netty4HttpRequest(msg.retain(), nonError));
        } else {
            out.add(new Netty4HttpRequest(msg.retain()));
        }
    }
}

