/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.transport.Transports;

public class Netty4HttpHeaderValidator
extends ChannelInboundHandlerAdapter {
    private final HttpValidator validator;
    private final ThreadContext threadContext;
    private ArrayDeque<HttpObject> pending = new ArrayDeque(4);
    private State state = State.WAITING_TO_START;

    public Netty4HttpHeaderValidator(HttpValidator validator, ThreadContext threadContext) {
        this.validator = validator;
        this.threadContext = threadContext;
    }

    State getState() {
        return this.state;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (msg instanceof HttpObject);
        HttpObject httpObject = (HttpObject)msg;
        switch (this.state) {
            case WAITING_TO_START: {
                assert (this.pending.isEmpty());
                this.pending.add((HttpObject)ReferenceCountUtil.retain((Object)httpObject));
                this.requestStart(ctx);
                assert (this.state == State.QUEUEING_DATA);
                break;
            }
            case QUEUEING_DATA: {
                this.pending.add((HttpObject)ReferenceCountUtil.retain((Object)httpObject));
                break;
            }
            case FORWARDING_DATA_UNTIL_NEXT_REQUEST: {
                assert (this.pending.isEmpty());
                if (httpObject instanceof LastHttpContent) {
                    this.state = State.WAITING_TO_START;
                }
                ctx.fireChannelRead((Object)httpObject);
                break;
            }
            case DROPPING_DATA_UNTIL_NEXT_REQUEST: {
                assert (this.pending.isEmpty());
                if (httpObject instanceof LastHttpContent) {
                    this.state = State.WAITING_TO_START;
                }
            }
            case DROPPING_DATA_PERMANENTLY: {
                assert (this.pending.isEmpty());
                ReferenceCountUtil.release((Object)httpObject);
            }
        }
        Netty4HttpHeaderValidator.setAutoReadForState(ctx, this.state);
    }

    private void requestStart(ChannelHandlerContext ctx) {
        assert (this.state == State.WAITING_TO_START);
        if (this.pending.isEmpty()) {
            return;
        }
        HttpObject httpObject = this.pending.getFirst();
        HttpRequest httpRequest = httpObject instanceof HttpRequest && httpObject.decoderResult().isSuccess() ? (HttpRequest)httpObject : null;
        this.state = State.QUEUEING_DATA;
        if (httpRequest == null) {
            ctx.channel().eventLoop().submit(() -> this.forwardFullRequest(ctx));
        } else {
            Transports.assertDefaultThreadContext(this.threadContext);
            ContextPreservingActionListener<Void> contextPreservingActionListener = new ContextPreservingActionListener<Void>(this.threadContext.wrapRestorable(this.threadContext.newStoredContext(false)), ActionListener.wrap(aVoid -> ctx.channel().eventLoop().submit(() -> this.forwardFullRequest(ctx)), e -> ctx.channel().eventLoop().submit(() -> this.forwardRequestWithDecoderExceptionAndNoContent(ctx, (Exception)e))));
            try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(false);){
                this.validator.validate(httpRequest, ctx.channel(), contextPreservingActionListener);
            }
        }
    }

    private void forwardFullRequest(ChannelHandlerContext ctx) {
        Transports.assertDefaultThreadContext(this.threadContext);
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (!ctx.channel().config().isAutoRead());
        assert (this.state == State.QUEUEING_DATA);
        boolean fullRequestForwarded = Netty4HttpHeaderValidator.forwardData(ctx, this.pending);
        assert (fullRequestForwarded || this.pending.isEmpty());
        if (fullRequestForwarded) {
            this.state = State.WAITING_TO_START;
            this.requestStart(ctx);
        } else {
            this.state = State.FORWARDING_DATA_UNTIL_NEXT_REQUEST;
        }
        assert (this.state == State.WAITING_TO_START || this.state == State.QUEUEING_DATA || this.state == State.FORWARDING_DATA_UNTIL_NEXT_REQUEST);
        Netty4HttpHeaderValidator.setAutoReadForState(ctx, this.state);
    }

    private void forwardRequestWithDecoderExceptionAndNoContent(ChannelHandlerContext ctx, Exception e) {
        Transports.assertDefaultThreadContext(this.threadContext);
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (!ctx.channel().config().isAutoRead());
        assert (this.state == State.QUEUEING_DATA);
        HttpObject messageToForward = this.pending.getFirst();
        boolean fullRequestDropped = Netty4HttpHeaderValidator.dropData(this.pending);
        if (messageToForward instanceof HttpContent) {
            messageToForward = ((HttpContent)messageToForward).replace(Unpooled.EMPTY_BUFFER);
        }
        messageToForward.setDecoderResult(DecoderResult.failure((Throwable)e));
        ctx.fireChannelRead((Object)messageToForward);
        assert (fullRequestDropped || this.pending.isEmpty());
        if (fullRequestDropped) {
            this.state = State.WAITING_TO_START;
            this.requestStart(ctx);
        } else {
            this.state = State.DROPPING_DATA_UNTIL_NEXT_REQUEST;
        }
        assert (this.state == State.WAITING_TO_START || this.state == State.QUEUEING_DATA || this.state == State.DROPPING_DATA_UNTIL_NEXT_REQUEST);
        Netty4HttpHeaderValidator.setAutoReadForState(ctx, this.state);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.state = State.DROPPING_DATA_PERMANENTLY;
        while (Netty4HttpHeaderValidator.dropData(this.pending)) {
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean forwardData(ChannelHandlerContext ctx, ArrayDeque<HttpObject> pending) {
        int pendingMessages = pending.size();
        try {
            HttpObject toForward;
            while ((toForward = pending.poll()) != null) {
                ctx.fireChannelRead((Object)toForward);
                ReferenceCountUtil.release((Object)toForward);
                if (!(toForward instanceof LastHttpContent)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Netty4HttpHeaderValidator.maybeResizePendingDown(pendingMessages, pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean dropData(ArrayDeque<HttpObject> pending) {
        int pendingMessages = pending.size();
        try {
            HttpObject toDrop;
            while ((toDrop = pending.poll()) != null) {
                ReferenceCountUtil.release((Object)toDrop, (int)2);
                if (!(toDrop instanceof LastHttpContent)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Netty4HttpHeaderValidator.maybeResizePendingDown(pendingMessages, pending);
        }
    }

    private static void maybeResizePendingDown(int largeSize, ArrayDeque<HttpObject> pending) {
        if (pending.size() <= 4 && largeSize > 32) {
            ArrayDeque<HttpObject> old = pending;
            pending = new ArrayDeque(4);
            pending.addAll(old);
        }
    }

    private static void setAutoReadForState(ChannelHandlerContext ctx, State state) {
        ctx.channel().config().setAutoRead(!(state == State.QUEUEING_DATA || state == State.DROPPING_DATA_PERMANENTLY));
    }

    static enum State {
        WAITING_TO_START,
        QUEUEING_DATA,
        FORWARDING_DATA_UNTIL_NEXT_REQUEST,
        DROPPING_DATA_UNTIL_NEXT_REQUEST,
        DROPPING_DATA_PERMANENTLY;

    }
}

