/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.CompletableContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;

public class Netty4HttpChannel
implements HttpChannel {
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4HttpChannel(Channel channel) {
        this.channel = channel;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
    }

    @Override
    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.channel.writeAndFlush((Object)response, Netty4TcpChannel.addPromise(listener, this.channel));
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return Netty4HttpChannel.castAddressOrNull(this.channel.localAddress());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return Netty4HttpChannel.castAddressOrNull(this.channel.remoteAddress());
    }

    private static InetSocketAddress castAddressOrNull(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }
}

