/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.gateway.GatewayService;

public class ClusterStateUpdaters {
    private static final Logger logger = LogManager.getLogger(ClusterStateUpdaters.class);

    static ClusterState setLocalNode(ClusterState clusterState, DiscoveryNode localNode) {
        return ClusterState.builder(clusterState).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).build()).build();
    }

    static ClusterState upgradeAndArchiveUnknownOrInvalidSettings(ClusterState clusterState, ClusterSettings clusterSettings) {
        Metadata.Builder metadataBuilder = Metadata.builder(clusterState.metadata());
        metadataBuilder.persistentSettings(clusterSettings.archiveUnknownOrInvalidSettings(clusterSettings.upgradeSettings(metadataBuilder.persistentSettings()), e -> ClusterStateUpdaters.logUnknownSetting("persistent", e), (e, ex) -> ClusterStateUpdaters.logInvalidSetting("persistent", e, ex)));
        metadataBuilder.transientSettings(clusterSettings.archiveUnknownOrInvalidSettings(clusterSettings.upgradeSettings(metadataBuilder.transientSettings()), e -> ClusterStateUpdaters.logUnknownSetting("transient", e), (e, ex) -> ClusterStateUpdaters.logInvalidSetting("transient", e, ex)));
        return ClusterState.builder(clusterState).metadata(metadataBuilder).build();
    }

    private static void logUnknownSetting(String settingType, Map.Entry<String, String> e) {
        logger.warn("ignoring unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private static void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex) {
        logger.warn(() -> new ParameterizedMessage("ignoring invalid {} setting: [{}] with value [{}]; archiving", settingType, e.getKey(), e.getValue()), (Throwable)ex);
    }

    static ClusterState recoverClusterBlocks(ClusterState state) {
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(state.blocks());
        if (Metadata.SETTING_READ_ONLY_SETTING.get(state.metadata().settings()).booleanValue()) {
            blocks.addGlobalBlock(Metadata.CLUSTER_READ_ONLY_BLOCK);
        }
        if (Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(state.metadata().settings()).booleanValue()) {
            blocks.addGlobalBlock(Metadata.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
        }
        for (IndexMetadata indexMetadata : state.metadata()) {
            blocks.addBlocks(indexMetadata);
        }
        return ClusterState.builder(state).blocks(blocks).build();
    }

    static ClusterState updateRoutingTable(ClusterState state) {
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(state.routingTable());
        for (IndexMetadata indexMetadata : state.metadata().indices().values()) {
            routingTableBuilder.addAsRecovery(indexMetadata);
        }
        routingTableBuilder.version(0L);
        return ClusterState.builder(state).routingTable(routingTableBuilder.build()).build();
    }

    static ClusterState removeStateNotRecoveredBlock(ClusterState state) {
        return ClusterState.builder(state).blocks(ClusterBlocks.builder().blocks(state.blocks()).removeGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build()).build();
    }

    public static ClusterState addStateNotRecoveredBlock(ClusterState state) {
        return ClusterState.builder(state).blocks(ClusterBlocks.builder().blocks(state.blocks()).addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build()).build();
    }

    static ClusterState mixCurrentStateAndRecoveredState(ClusterState currentState, ClusterState recoveredState) {
        assert (currentState.metadata().indices().isEmpty());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).blocks(recoveredState.blocks());
        Metadata.Builder metadataBuilder = Metadata.builder(recoveredState.metadata());
        metadataBuilder.generateClusterUuidIfNeeded();
        for (IndexMetadata indexMetadata : recoveredState.metadata()) {
            metadataBuilder.put(indexMetadata, false);
        }
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadataBuilder).build();
    }

    public static ClusterState hideStateIfNotRecovered(ClusterState state) {
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(state.blocks());
            blocks.removeGlobalBlock(Metadata.CLUSTER_READ_ONLY_BLOCK);
            blocks.removeGlobalBlock(Metadata.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            for (IndexMetadata indexMetadata : state.metadata()) {
                blocks.removeIndexBlocks(indexMetadata.getIndex().getName());
            }
            Metadata metadata = Metadata.builder().clusterUUID(state.metadata().clusterUUID()).coordinationMetadata(state.metadata().coordinationMetadata()).build();
            return ClusterState.builder(state).metadata(metadata).blocks(blocks.build()).build();
        }
        return state;
    }
}

