/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.gateway.PersistedClusterStateService;

public class NodeRepurposeCommand
extends ElasticsearchNodeCommand {
    static final String ABORTED_BY_USER_MSG = "aborted by user";
    static final String FAILED_TO_OBTAIN_NODE_LOCK_MSG = "failed to lock node's directory, is Elasticsearch still running?";
    static final String NO_CLEANUP = "Node has node.data=true -> no clean up necessary";
    static final String NO_DATA_TO_CLEAN_UP_FOUND = "No data to clean-up found";
    static final String NO_SHARD_DATA_TO_CLEAN_UP_FOUND = "No shard data to clean-up found";

    public NodeRepurposeCommand() {
        super("Repurpose this node to another master/data role, cleaning up any excess persisted data");
    }

    void testExecute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        this.execute(terminal, options, env);
    }

    @Override
    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        Settings settings = env.settings();
        if (DiscoveryNode.canContainData(settings)) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_CLEANUP);
            return false;
        }
        return true;
    }

    @Override
    protected void processDataPaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException {
        assert (!DiscoveryNode.canContainData(env.settings()));
        if (!DiscoveryNode.isMasterNode(env.settings())) {
            this.processNoMasterNoDataNode(terminal, dataPaths, env);
        } else {
            this.processMasterNoDataNode(terminal, dataPaths, env);
        }
    }

    private void processNoMasterNoDataNode(Terminal terminal, Path[] paths, Environment env) throws IOException {
        NodeEnvironment.DataPath[] dataPaths = this.toDataPaths(paths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Collecting shard data paths");
        List<Path> shardDataPaths = NodeEnvironment.collectShardDataPaths(dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Collecting index metadata paths");
        List<Path> indexMetadataPaths = NodeEnvironment.collectIndexMetadataPaths(dataPaths);
        Set<Path> indexPaths = this.uniqueParentPaths(shardDataPaths, indexMetadataPaths);
        PersistedClusterStateService persistedClusterStateService = NodeRepurposeCommand.createPersistedClusterStateService(env.settings(), paths);
        Metadata metadata = this.loadClusterState(terminal, env, persistedClusterStateService).metadata();
        if (indexPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        Set<String> indexUUIDs = Sets.union(this.indexUUIDsFor(indexPaths), metadata.indices().values().stream().map(IndexMetadata::getIndexUUID).collect(Collectors.toSet()));
        this.outputVerboseInformation(terminal, indexPaths, indexUUIDs, metadata);
        terminal.println(NodeRepurposeCommand.noMasterMessage(indexUUIDs.size(), shardDataPaths.size(), indexMetadataPaths.size()));
        this.outputHowToSeeVerboseInformation(terminal);
        terminal.println("Node is being re-purposed as no-master and no-data. Clean-up of index data will be performed.");
        this.confirm(terminal, "Do you want to proceed?");
        this.removePaths(terminal, indexPaths);
        MetadataStateFormat.deleteMetaState(paths);
        IOUtils.rm((Path[])Stream.of(dataPaths).map(path -> path.resolve("indices")).toArray(Path[]::new));
        terminal.println("Node successfully repurposed to no-master and no-data.");
    }

    private void processMasterNoDataNode(Terminal terminal, Path[] paths, Environment env) throws IOException {
        NodeEnvironment.DataPath[] dataPaths = this.toDataPaths(paths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Collecting shard data paths");
        List<Path> shardDataPaths = NodeEnvironment.collectShardDataPaths(dataPaths);
        if (shardDataPaths.isEmpty()) {
            terminal.println(NO_SHARD_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        PersistedClusterStateService persistedClusterStateService = NodeRepurposeCommand.createPersistedClusterStateService(env.settings(), paths);
        Metadata metadata = this.loadClusterState(terminal, env, persistedClusterStateService).metadata();
        Set<Path> indexPaths = this.uniqueParentPaths(shardDataPaths);
        Set<String> indexUUIDs = this.indexUUIDsFor(indexPaths);
        this.outputVerboseInformation(terminal, shardDataPaths, indexUUIDs, metadata);
        terminal.println(NodeRepurposeCommand.shardMessage(shardDataPaths.size(), indexUUIDs.size()));
        this.outputHowToSeeVerboseInformation(terminal);
        terminal.println("Node is being re-purposed as master and no-data. Clean-up of shard data will be performed.");
        this.confirm(terminal, "Do you want to proceed?");
        this.removePaths(terminal, shardDataPaths);
        terminal.println("Node successfully repurposed to master and no-data.");
    }

    private ClusterState loadClusterState(Terminal terminal, Environment env, PersistedClusterStateService psf) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        return NodeRepurposeCommand.clusterState(env, psf.loadBestOnDiskState());
    }

    private void outputVerboseInformation(Terminal terminal, Collection<Path> pathsToCleanup, Set<String> indexUUIDs, Metadata metadata) {
        if (terminal.isPrintable(Terminal.Verbosity.VERBOSE)) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Paths to clean up:");
            pathsToCleanup.forEach(p -> terminal.println(Terminal.Verbosity.VERBOSE, "  " + p.toString()));
            terminal.println(Terminal.Verbosity.VERBOSE, "Indices affected:");
            indexUUIDs.forEach(uuid -> terminal.println(Terminal.Verbosity.VERBOSE, "  " + this.toIndexName((String)uuid, metadata)));
        }
    }

    private void outputHowToSeeVerboseInformation(Terminal terminal) {
        if (!terminal.isPrintable(Terminal.Verbosity.VERBOSE)) {
            terminal.println("Use -v to see list of paths and indices affected");
        }
    }

    private String toIndexName(String uuid, Metadata metadata) {
        if (metadata != null) {
            for (ObjectObjectCursor<String, IndexMetadata> objectObjectCursor : metadata.indices()) {
                if (!((IndexMetadata)objectObjectCursor.value).getIndexUUID().equals(uuid)) continue;
                return ((IndexMetadata)objectObjectCursor.value).getIndex().getName();
            }
        }
        return "no name for uuid: " + uuid;
    }

    private Set<String> indexUUIDsFor(Set<Path> indexPaths) {
        return indexPaths.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
    }

    static String noMasterMessage(int indexes, int shards, int indexMetadata) {
        return "Found " + indexes + " indices (" + shards + " shards and " + indexMetadata + " index meta data) to clean up";
    }

    static String shardMessage(int shards, int indices) {
        return "Found " + shards + " shards in " + indices + " indices to clean up";
    }

    private void removePaths(Terminal terminal, Collection<Path> paths) {
        terminal.println(Terminal.Verbosity.VERBOSE, "Removing data");
        paths.forEach(this::removePath);
    }

    private void removePath(Path path) {
        try {
            IOUtils.rm(path);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to clean up path: " + path + ": " + e.getMessage(), new Object[0]);
        }
    }

    @SafeVarargs
    private final Set<Path> uniqueParentPaths(Collection<Path> ... paths) {
        return Arrays.stream(paths).flatMap(Collection::stream).map(Path::getParent).collect(Collectors.toSet());
    }

    OptionParser getParser() {
        return this.parser;
    }
}

