/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class NodeMetadata {
    static final String NODE_ID_KEY = "node_id";
    static final String NODE_VERSION_KEY = "node_version";
    private static final String OLDEST_INDEX_VERSION_KEY = "oldest_index_version";
    private final String nodeId;
    private final Version nodeVersion;
    private final Version oldestIndexVersion;
    public static final MetadataStateFormat<NodeMetadata> FORMAT = new NodeMetadataStateFormat(false);

    public NodeMetadata(String nodeId, Version nodeVersion, Version oldestIndexVersion) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.oldestIndexVersion = Objects.requireNonNull(oldestIndexVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetadata that = (NodeMetadata)o;
        return this.nodeId.equals(that.nodeId) && this.nodeVersion.equals(that.nodeVersion) && this.oldestIndexVersion.equals(that.oldestIndexVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeVersion, this.oldestIndexVersion);
    }

    public String toString() {
        return "NodeMetadata{nodeId='" + this.nodeId + '\'' + ", nodeVersion=" + this.nodeVersion + ", oldestIndexVersion=" + this.oldestIndexVersion + '}';
    }

    public String nodeId() {
        return this.nodeId;
    }

    public Version nodeVersion() {
        return this.nodeVersion;
    }

    public Version oldestIndexVersion() {
        return this.oldestIndexVersion;
    }

    public NodeMetadata upgradeToCurrentVersion() {
        if (this.nodeVersion.equals(Version.V_EMPTY)) {
            assert (Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "version is required in the node metadata from v9 onwards";
            return new NodeMetadata(this.nodeId, Version.CURRENT, this.oldestIndexVersion);
        }
        if (this.nodeVersion.before(Version.CURRENT.minimumIndexCompatibilityVersion())) {
            throw new IllegalStateException("cannot upgrade a node from version [" + this.nodeVersion + "] directly to version [" + Version.CURRENT + "]");
        }
        if (this.nodeVersion.after(Version.CURRENT)) {
            throw new IllegalStateException("cannot downgrade a node from version [" + this.nodeVersion + "] to version [" + Version.CURRENT + "]");
        }
        return this.nodeVersion.equals(Version.CURRENT) ? this : new NodeMetadata(this.nodeId, Version.CURRENT, this.oldestIndexVersion);
    }

    static class NodeMetadataStateFormat
    extends MetadataStateFormat<NodeMetadata> {
        private ObjectParser<Builder, Void> objectParser;

        NodeMetadataStateFormat(boolean ignoreUnknownFields) {
            super("node-");
            this.objectParser = new ObjectParser("node_meta_data", ignoreUnknownFields, () -> new Builder());
            this.objectParser.declareString(Builder::setNodeId, new ParseField(NodeMetadata.NODE_ID_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setNodeVersionId, new ParseField(NodeMetadata.NODE_VERSION_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setOldestIndexVersion, new ParseField(NodeMetadata.OLDEST_INDEX_VERSION_KEY, new String[0]));
        }

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, NodeMetadata nodeMetadata) throws IOException {
            builder.field(NodeMetadata.NODE_ID_KEY, nodeMetadata.nodeId);
            builder.field(NodeMetadata.NODE_VERSION_KEY, ((NodeMetadata)nodeMetadata).nodeVersion.id);
            builder.field(NodeMetadata.OLDEST_INDEX_VERSION_KEY, ((NodeMetadata)nodeMetadata).oldestIndexVersion.id);
        }

        @Override
        public NodeMetadata fromXContent(XContentParser parser) throws IOException {
            return this.objectParser.apply(parser, null).build();
        }
    }

    private static class Builder {
        String nodeId;
        Version nodeVersion;
        Version oldestIndexVersion;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void setNodeVersionId(int nodeVersionId) {
            this.nodeVersion = Version.fromId(nodeVersionId);
        }

        public void setOldestIndexVersion(int oldestIndexVersionId) {
            this.oldestIndexVersion = Version.fromId(oldestIndexVersionId);
        }

        public NodeMetadata build() {
            Version nodeVersion;
            if (this.nodeVersion == null) {
                assert (Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "version is required in the node metadata from v9 onwards";
                nodeVersion = Version.V_EMPTY;
            } else {
                nodeVersion = this.nodeVersion;
            }
            Version oldestIndexVersion = this.oldestIndexVersion == null ? Version.V_EMPTY : this.oldestIndexVersion;
            return new NodeMetadata(this.nodeId, nodeVersion, oldestIndexVersion);
        }
    }
}

