/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamAlias
extends AbstractDiffable<DataStreamAlias>
implements ToXContentFragment {
    public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
    public static final ParseField WRITE_DATA_STREAM_FIELD = new ParseField("write_data_stream", new String[0]);
    public static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]);
    private static final ConstructingObjectParser<DataStreamAlias, String> PARSER = new ConstructingObjectParser<DataStreamAlias, String>("data_stream_alias", false, (args, name) -> new DataStreamAlias((String)name, (List)args[0], (String)args[1], (CompressedXContent)args[2]));
    private final String name;
    private final List<String> dataStreams;
    private final String writeDataStream;
    private final CompressedXContent filter;

    private DataStreamAlias(String name, Collection<String> dataStreams, String writeDataStream, CompressedXContent filter) {
        this.name = Objects.requireNonNull(name);
        this.dataStreams = Collections.unmodifiableList(new ArrayList<String>(dataStreams));
        this.writeDataStream = writeDataStream;
        this.filter = filter;
        assert (writeDataStream == null || dataStreams.contains(writeDataStream));
    }

    public DataStreamAlias(String name, List<String> dataStreams, String writeDataStream, Map<String, Object> filter) {
        this(name, dataStreams, writeDataStream, DataStreamAlias.compress(filter));
    }

    private static CompressedXContent compress(Map<String, Object> filterAsMap) {
        if (filterAsMap == null) {
            return null;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().map(filterAsMap);
            return new CompressedXContent(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map<String, Object> decompress(CompressedXContent filter) {
        String filterAsString = filter.string();
        return XContentHelper.convertToMap(XContentFactory.xContent(filterAsString), filterAsString, true);
    }

    public DataStreamAlias(StreamInput in) throws IOException {
        this.name = in.readString();
        this.dataStreams = in.readStringList();
        this.writeDataStream = in.readOptionalString();
        this.filter = in.getVersion().onOrAfter(Version.V_7_15_0) && in.readBoolean() ? CompressedXContent.readCompressedString(in) : null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDataStreams() {
        return this.dataStreams;
    }

    public String getWriteDataStream() {
        return this.writeDataStream;
    }

    public CompressedXContent getFilter() {
        return this.filter;
    }

    public boolean filteringRequired() {
        return this.filter != null;
    }

    public DataStreamAlias update(String dataStream, Boolean isWriteDataStream, Map<String, Object> filterAsMap) {
        boolean filterUpdated;
        CompressedXContent filter;
        String writeDataStream = this.writeDataStream;
        if (isWriteDataStream != null) {
            if (isWriteDataStream.booleanValue()) {
                writeDataStream = dataStream;
            } else if (dataStream.equals(writeDataStream)) {
                writeDataStream = null;
            }
        }
        if (filterAsMap != null) {
            filter = DataStreamAlias.compress(filterAsMap);
            filterUpdated = this.filter == null ? true : !filterAsMap.equals(DataStreamAlias.decompress(this.filter));
        } else {
            filter = this.filter;
            filterUpdated = false;
        }
        HashSet<String> dataStreams = new HashSet<String>(this.dataStreams);
        boolean added = dataStreams.add(dataStream);
        if (added || !Objects.equals(this.writeDataStream, writeDataStream) || filterUpdated) {
            return new DataStreamAlias(this.name, dataStreams, writeDataStream, filter);
        }
        return this;
    }

    public DataStreamAlias removeDataStream(String dataStream) {
        HashSet<String> dataStreams = new HashSet<String>(this.dataStreams);
        boolean removed = dataStreams.remove(dataStream);
        if (!removed) {
            return this;
        }
        if (dataStreams.isEmpty()) {
            return null;
        }
        String writeDataStream = this.writeDataStream;
        if (dataStream.equals(writeDataStream)) {
            writeDataStream = null;
        }
        return new DataStreamAlias(this.name, dataStreams, writeDataStream, this.filter);
    }

    public DataStreamAlias intersect(Predicate<String> filter) {
        String writeDataStream;
        List<String> intersectingDataStreams = this.dataStreams.stream().filter(filter).collect(Collectors.toList());
        if (!intersectingDataStreams.contains(writeDataStream = this.writeDataStream)) {
            writeDataStream = null;
        }
        return new DataStreamAlias(this.name, intersectingDataStreams, writeDataStream, this.filter);
    }

    public DataStreamAlias merge(DataStreamAlias other) {
        HashSet<String> mergedDataStreams = new HashSet<String>(other.getDataStreams());
        mergedDataStreams.addAll(this.getDataStreams());
        String writeDataStream = this.writeDataStream;
        if (writeDataStream == null && other.getWriteDataStream() != null && mergedDataStreams.contains(other.getWriteDataStream())) {
            writeDataStream = other.getWriteDataStream();
        }
        return new DataStreamAlias(this.name, mergedDataStreams, writeDataStream, this.filter);
    }

    public DataStreamAlias renameDataStreams(String renamePattern, String renameReplacement) {
        List<String> renamedDataStreams = this.dataStreams.stream().map(s -> s.replaceAll(renamePattern, renameReplacement)).collect(Collectors.toList());
        String writeDataStream = this.writeDataStream;
        if (writeDataStream != null) {
            writeDataStream = writeDataStream.replaceAll(renamePattern, renameReplacement);
        }
        return new DataStreamAlias(this.name, renamedDataStreams, writeDataStream, this.filter);
    }

    public static Diff<DataStreamAlias> readDiffFrom(StreamInput in) throws IOException {
        return DataStreamAlias.readDiffFrom(DataStreamAlias::new, in);
    }

    public static DataStreamAlias fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        String name = parser.currentName();
        return PARSER.parse(parser, name);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.stringListField(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
        if (this.writeDataStream != null) {
            builder.field(WRITE_DATA_STREAM_FIELD.getPreferredName(), this.writeDataStream);
        }
        if (this.filter != null) {
            boolean binary = params.paramAsBoolean("binary", false);
            if (binary) {
                builder.field("filter", this.filter.compressed());
            } else {
                builder.field("filter", XContentHelper.convertToMap(this.filter.uncompressed(), true).v2());
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.dataStreams);
        out.writeOptionalString(this.writeDataStream);
        if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
            if (this.filter != null) {
                out.writeBoolean(true);
                this.filter.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamAlias that = (DataStreamAlias)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataStreams, that.dataStreams) && Objects.equals(this.writeDataStream, that.writeDataStream) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataStreams, this.writeDataStream, this.filter);
    }

    public String toString() {
        return "DataStreamAlias{name='" + this.name + '\'' + ", dataStreams=" + this.dataStreams + ", writeDataStream='" + this.writeDataStream + '\'' + ", filter=" + (this.filter != null ? this.filter.string() : "null") + '}';
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), DATA_STREAMS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), WRITE_DATA_STREAM_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_EMBEDDED_OBJECT || p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new CompressedXContent(p.binaryValue());
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentBuilder builder = XContentFactory.jsonBuilder().map(p.mapOrdered());
                return new CompressedXContent(BytesReference.bytes(builder));
            }
            assert (false) : "unexpected token [" + (Object)((Object)p.currentToken()) + " ]";
            return null;
        }, FILTER_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
    }
}

